/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.geocoder;

import com.google.maps.GeoApiContext;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.geocoder.GeoCoderEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="geocoder")
public class GeoCoderComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private GeoApiContext geoApiContext;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        GeoCoderEndpoint endpoint = new GeoCoderEndpoint(uri, this);
        if (remaining.startsWith("address:")) {
            String adr = remaining.substring(8);
            endpoint.setAddress(adr);
        } else if (remaining.startsWith("latlng:")) {
            String latlng = remaining.substring(7);
            endpoint.setLatlng(latlng);
        } else {
            throw new IllegalArgumentException("URI context path should be either address: or latlng:, was: " + remaining);
        }
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public GeoApiContext getGeoApiContext() {
        return this.geoApiContext;
    }

    public void setGeoApiContext(GeoApiContext geoApiContext) {
        this.geoApiContext = geoApiContext;
    }
}

