/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.consumer;

import java.util.List;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.consumer.AbstractGitHubConsumer;
import org.apache.camel.spi.Registry;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.service.CommitService;
import org.eclipse.egit.github.core.service.GitHubService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitConsumer
extends AbstractGitHubConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(CommitConsumer.class);
    private CommitService commitService;
    private final String branchName;
    private final String startingSha;
    private final Queue<String> commitHashes = new ArrayBlockingQueue<String>(100);
    private volatile String lastSha;

    public CommitConsumer(GitHubEndpoint endpoint, Processor processor, String branchName, String startingSha) throws Exception {
        super(endpoint, processor);
        this.branchName = branchName;
        this.startingSha = startingSha;
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubCommitService");
        if (service != null) {
            LOG.debug("Using CommitService found in registry {}", (Object)service.getClass().getCanonicalName());
            this.commitService = (CommitService)service;
        } else {
            this.commitService = new CommitService();
        }
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.initService((GitHubService)this.commitService);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.commitHashes.clear();
        this.lastSha = null;
        if (this.startingSha.equals("last")) {
            LOG.info("GitHub CommitConsumer: Indexing current commits...");
            List commits = this.commitService.getCommits((IRepositoryIdProvider)this.getRepository(), this.branchName, null);
            for (RepositoryCommit commit : commits) {
                String sha = commit.getSha();
                this.commitHashes.add(sha);
                if (this.lastSha != null) continue;
                this.lastSha = sha;
            }
            LOG.info("GitHub CommitConsumer: Starting from last sha: {}", (Object)this.lastSha);
        } else if (!this.startingSha.equals("beginning")) {
            this.lastSha = this.startingSha;
            LOG.info("GitHub CommitConsumer: Starting from sha: {}", (Object)this.lastSha);
        } else {
            LOG.info("GitHub CommitConsumer: Starting from beginning");
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.commitHashes.clear();
        this.lastSha = null;
    }

    @Override
    protected int poll() throws Exception {
        List commits = this.lastSha != null ? this.commitService.getCommits((IRepositoryIdProvider)this.getRepository(), this.lastSha, null) : this.commitService.getCommits((IRepositoryIdProvider)this.getRepository());
        Stack<RepositoryCommit> newCommits = new Stack<RepositoryCommit>();
        for (RepositoryCommit commit : commits) {
            if (this.commitHashes.contains(commit.getSha())) continue;
            newCommits.push(commit);
            this.commitHashes.add(commit.getSha());
            this.lastSha = commit.getSha();
        }
        while (!newCommits.empty()) {
            RepositoryCommit newCommit = (RepositoryCommit)newCommits.pop();
            Exchange e = this.createExchange(true);
            e.getMessage().setHeader("CamelGitHubCommitAuthor", (Object)newCommit.getAuthor().getName());
            e.getMessage().setHeader("CamelGitHubCommitCommitter", (Object)newCommit.getCommitter().getName());
            e.getMessage().setHeader("CamelGitHubCommitSha", (Object)newCommit.getSha());
            e.getMessage().setHeader("CamelGitHubCommitUrl", (Object)newCommit.getUrl());
            e.getMessage().setBody((Object)newCommit.getCommit().getMessage());
            this.getProcessor().process(e);
        }
        return newCommits.size();
    }
}

