/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.consumer;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.consumer.AbstractGitHubConsumer;
import org.apache.camel.spi.Registry;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.service.CommitService;
import org.eclipse.egit.github.core.service.GitHubService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitConsumer
extends AbstractGitHubConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(CommitConsumer.class);
    private static final int CAPACITY = 1000;
    private CommitService commitService;
    private final String branchName;
    private final String startingSha;
    private final Queue<String> commitHashes = new LinkedBlockingQueue<String>(1000);
    private volatile String lastSha;
    private boolean started = false;

    public CommitConsumer(GitHubEndpoint endpoint, Processor processor, String branchName, String startingSha) throws Exception {
        super(endpoint, processor);
        this.branchName = branchName;
        this.startingSha = startingSha;
    }

    public GitHubEndpoint getEndpoint() {
        return (GitHubEndpoint)super.getEndpoint();
    }

    protected void doInit() throws Exception {
        super.doInit();
        Registry registry = this.getEndpoint().getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubCommitService");
        if (service != null) {
            LOG.debug("Using CommitService found in registry {}", (Object)service.getClass().getCanonicalName());
            this.commitService = (CommitService)service;
        } else {
            this.commitService = new CommitService();
        }
        this.initService((GitHubService)this.commitService);
    }

    protected void doStart() throws Exception {
        this.lock.lock();
        try {
            super.doStart();
            this.commitHashes.clear();
            this.lastSha = null;
            if (this.startingSha.equals("last")) {
                LOG.info("Indexing current commits on: {}/{}@{}", new Object[]{this.getEndpoint().getRepoOwner(), this.getEndpoint().getRepoName(), this.branchName});
                List commits = this.commitService.getCommits((IRepositoryIdProvider)this.getRepository(), this.branchName, null);
                if (!commits.isEmpty()) {
                    this.lastSha = ((RepositoryCommit)commits.get(0)).getSha();
                }
                LOG.info("Starting from last sha: {}", (Object)this.lastSha);
            } else if (!this.startingSha.equals("beginning")) {
                this.lastSha = this.startingSha;
                LOG.info("Starting from sha: {}", (Object)this.lastSha);
            } else {
                LOG.info("Starting from beginning");
            }
            this.started = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void doStop() throws Exception {
        this.lock.lock();
        try {
            super.doStop();
            this.commitHashes.clear();
            this.lastSha = null;
            this.started = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int poll() throws Exception {
        this.lock.lock();
        try {
            if (!this.started) {
                int n = 0;
                return n;
            }
            List commits = this.commitService.getCommits((IRepositoryIdProvider)this.getRepository(), this.branchName, null);
            if (this.lastSha != null) {
                int pos = -1;
                for (int i = 0; i < commits.size(); ++i) {
                    RepositoryCommit commit = (RepositoryCommit)commits.get(i);
                    if (!this.lastSha.equals(commit.getSha())) continue;
                    pos = i;
                    break;
                }
                if (pos != -1) {
                    commits = commits.subList(0, pos);
                }
            }
            ArrayDeque<RepositoryCommit> newCommits = new ArrayDeque<RepositoryCommit>();
            for (RepositoryCommit commit : commits) {
                String sha = commit.getSha();
                if (this.commitHashes.contains(sha)) continue;
                newCommits.push(commit);
                while (this.commitHashes.size() > 999) {
                    this.commitHashes.remove();
                }
                this.commitHashes.add(sha);
            }
            int counter = 0;
            while (!newCommits.isEmpty()) {
                RepositoryCommit newCommit = (RepositoryCommit)newCommits.pop();
                this.lastSha = newCommit.getSha();
                Exchange e = this.createExchange(true);
                if (newCommit.getAuthor() != null) {
                    e.getMessage().setHeader("CamelGitHubCommitAuthor", (Object)newCommit.getAuthor().getName());
                }
                if (newCommit.getCommitter() != null) {
                    e.getMessage().setHeader("CamelGitHubCommitCommitter", (Object)newCommit.getCommitter().getName());
                }
                e.getMessage().setHeader("CamelGitHubCommitSha", (Object)newCommit.getSha());
                e.getMessage().setHeader("CamelGitHubCommitUrl", (Object)newCommit.getUrl());
                e.getMessage().setBody((Object)newCommit.getCommit().getMessage());
                this.getProcessor().process(e);
                ++counter;
            }
            LOG.debug("Last sha: {}", (Object)this.lastSha);
            int n = counter;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }
}

