/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery.sql;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.bigquery.GoogleBigQueryConnectionFactory;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLConfiguration;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLEndpoint;
import org.apache.camel.impl.DefaultComponent;

public class GoogleBigQuerySQLComponent
extends DefaultComponent {
    private String projectId;
    private GoogleBigQueryConnectionFactory connectionFactory;

    public GoogleBigQuerySQLComponent() {
    }

    public GoogleBigQuerySQLComponent(CamelContext camelContext) {
        super(camelContext);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String[] parts = remaining.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Google BigQuery Endpoint format \"projectId:<query>\"");
        }
        GoogleBigQuerySQLConfiguration configuration = new GoogleBigQuerySQLConfiguration();
        this.setProperties(configuration, parameters);
        configuration.parseRemaining(remaining);
        if (configuration.getConnectionFactory() == null) {
            configuration.setConnectionFactory(this.getConnectionFactory());
        }
        return new GoogleBigQuerySQLEndpoint(uri, this, configuration);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public GoogleBigQueryConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new GoogleBigQueryConnectionFactory();
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(GoogleBigQueryConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

