/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery;

import com.google.api.client.util.Strings;
import com.google.api.services.bigquery.BigqueryScopes;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleBigQueryConnectionFactory {
    private final Logger logger = LoggerFactory.getLogger(GoogleBigQueryConnectionFactory.class);
    private String credentialsFileLocation;
    private String serviceURL;
    private BigQuery client;

    public GoogleBigQueryConnectionFactory() {
    }

    public GoogleBigQueryConnectionFactory(BigQuery client) {
        this.client = client;
    }

    public synchronized BigQuery getDefaultClient() throws Exception {
        if (this.client == null) {
            this.client = this.buildClient();
        }
        return this.client;
    }

    private BigQuery buildClient() throws Exception {
        GoogleCredentials credentials = null;
        if (credentials == null && !Strings.isNullOrEmpty((String)this.credentialsFileLocation)) {
            this.logger.debug("Key File Name has been set explicitly. Initialising BigQuery using Key File {}", (Object)this.credentialsFileLocation);
            credentials = this.createFromFile();
        }
        if (credentials == null) {
            this.logger.debug("No explicit Service Account or Key File Name have been provided. Initialising BigQuery using defaults");
            credentials = this.createDefault();
        }
        BigQueryOptions.Builder builder = (BigQueryOptions.Builder)BigQueryOptions.newBuilder().setCredentials(credentials);
        if (ObjectHelper.isNotEmpty((Object)this.serviceURL)) {
            builder.setHost(this.serviceURL);
        }
        return (BigQuery)builder.build().getService();
    }

    private GoogleCredentials createFromFile() throws Exception {
        try (FileInputStream is = new FileInputStream(this.credentialsFileLocation);){
            GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)is);
            if (credentials.createScopedRequired()) {
                credentials = credentials.createScoped((Collection)BigqueryScopes.all());
            }
            GoogleCredentials googleCredentials = credentials;
            return googleCredentials;
        }
    }

    private GoogleCredentials createDefault() throws Exception {
        GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
        List<String> scopes = Collections.singletonList("https://www.googleapis.com/auth/bigquery");
        if (credentials.createScopedRequired()) {
            credentials = credentials.createScoped(scopes);
        }
        return credentials;
    }

    public String getCredentialsFileLocation() {
        return this.credentialsFileLocation;
    }

    public GoogleBigQueryConnectionFactory setCredentialsFileLocation(String credentialsFileLocation) {
        this.credentialsFileLocation = credentialsFileLocation;
        this.resetClient();
        return this;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public GoogleBigQueryConnectionFactory setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
        this.resetClient();
        return this;
    }

    private synchronized void resetClient() {
        this.client = null;
    }
}

