/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery;

import com.google.cloud.bigquery.BigQuery;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.bigquery.GoogleBigQueryComponent;
import org.apache.camel.component.google.bigquery.GoogleBigQueryConfiguration;
import org.apache.camel.component.google.bigquery.GoogleBigQueryConnectionFactory;
import org.apache.camel.component.google.bigquery.GoogleBigQueryConstants;
import org.apache.camel.component.google.bigquery.GoogleBigQueryProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.20.0", scheme="google-bigquery", title="Google BigQuery", syntax="google-bigquery:projectId:datasetId:tableId", category={Category.CLOUD, Category.BIGDATA}, producerOnly=true, headersClass=GoogleBigQueryConstants.class)
public class GoogleBigQueryEndpoint
extends DefaultEndpoint {
    @UriParam
    protected final GoogleBigQueryConfiguration configuration;
    private BigQuery bigQuery;

    protected GoogleBigQueryEndpoint(String endpointUri, GoogleBigQueryComponent component, GoogleBigQueryConfiguration configuration) {
        super(endpointUri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        return new GoogleBigQueryProducer(this.bigQuery, this, this.configuration);
    }

    protected void doStart() throws Exception {
        super.doStart();
        GoogleBigQueryConnectionFactory connFactory = this.configuration.getConnectionFactory();
        if (connFactory == null) {
            connFactory = new GoogleBigQueryConnectionFactory().setCamelContext(this.getCamelContext()).setServiceAccountKeyFile(this.configuration.getServiceAccountKey());
            this.configuration.setConnectionFactory(connFactory);
        }
        this.bigQuery = connFactory.getDefaultClient();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from the BigQuery endpoint: " + this.getEndpointUri());
    }

    public GoogleBigQueryConfiguration getConfiguration() {
        return this.configuration;
    }

    public GoogleBigQueryComponent getComponent() {
        return (GoogleBigQueryComponent)super.getComponent();
    }
}

