/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery.sql;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.bigquery.GoogleBigQueryConnectionFactory;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLConfiguration;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="google-bigquery-sql")
public class GoogleBigQuerySQLComponent
extends DefaultComponent {
    @Metadata
    private String projectId;
    @Metadata
    private GoogleBigQuerySQLConfiguration configuration;
    @Metadata(autowired=true)
    private GoogleBigQueryConnectionFactory connectionFactory;

    public GoogleBigQuerySQLComponent() {
    }

    public GoogleBigQuerySQLComponent(GoogleBigQuerySQLConfiguration configuration) {
        this.configuration = configuration;
    }

    public GoogleBigQuerySQLComponent(CamelContext camelContext) {
        super(camelContext);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String[] parts = remaining.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Google BigQuery Endpoint format \"projectId:<query>\"");
        }
        GoogleBigQuerySQLConfiguration conf = this.configuration != null ? this.configuration.copy() : new GoogleBigQuerySQLConfiguration();
        conf.parseRemaining(remaining);
        GoogleBigQuerySQLEndpoint endpoint = new GoogleBigQuerySQLEndpoint(uri, this, conf);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public GoogleBigQueryConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(GoogleBigQueryConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public GoogleBigQuerySQLConfiguration getConfiguration() {
        return this.configuration;
    }
}

