/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.calendar.stream;

import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.model.Event;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamComponent;
import org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamConfiguration;
import org.apache.camel.component.google.calendar.stream.GoogleCalendarStreamConsumer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.23.0", scheme="google-calendar-stream", title="Google Calendar Stream", syntax="google-calendar-stream:index", consumerOnly=true, category={Category.CLOUD})
public class GoogleCalendarStreamEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private GoogleCalendarStreamConfiguration configuration;

    public GoogleCalendarStreamEndpoint(String uri, GoogleCalendarStreamComponent component, GoogleCalendarStreamConfiguration endpointConfiguration) {
        super(uri, (Component)component);
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("The camel google calendar stream component doesn't support producer");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.configuration.isSyncFlow()) {
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getQuery())) {
                throw new IllegalArgumentException("'query' parameter is incompatible with sync flow.");
            }
            if (this.configuration.isConsiderLastUpdate()) {
                throw new IllegalArgumentException("'considerLastUpdate' is incompatible with sync flow.");
            }
        }
        GoogleCalendarStreamConsumer consumer = new GoogleCalendarStreamConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Calendar getClient() {
        return ((GoogleCalendarStreamComponent)this.getComponent()).getClient(this.configuration);
    }

    public GoogleCalendarStreamConfiguration getConfiguration() {
        return this.configuration;
    }

    public Exchange createExchange(ExchangePattern pattern, Event event) {
        Exchange exchange = super.createExchange(pattern);
        Message message = exchange.getIn();
        message.setBody((Object)event);
        message.setHeader("CamelGoogleCalendarEventId", (Object)event.getId());
        return exchange;
    }
}

