/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.services.drive.model.Drive;
import org.apache.camel.component.google.drive.GoogleDriveConfiguration;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@ApiParams(apiName="drive-drives", description="The drives collection of methods", apiMethods={@ApiMethod(methodName="delete", description="Permanently deletes a shared drive for which the user is an organizer", signatures={"com.google.api.services.drive.Drive$Drives$Delete delete(String driveId)"}), @ApiMethod(methodName="get", description="Gets a shared drive's metadata by ID", signatures={"com.google.api.services.drive.Drive$Drives$Get get(String driveId)"}), @ApiMethod(methodName="hide", description="Hides a shared drive from the default view", signatures={"com.google.api.services.drive.Drive$Drives$Hide hide(String driveId)"}), @ApiMethod(methodName="insert", description="Creates a new shared drive", signatures={"com.google.api.services.drive.Drive$Drives$Insert insert(String requestId, com.google.api.services.drive.model.Drive content)"}), @ApiMethod(methodName="list", description="Lists the user's shared drives", signatures={"com.google.api.services.drive.Drive$Drives$List list()"}), @ApiMethod(methodName="unhide", description="Restores a shared drive to the default view", signatures={"com.google.api.services.drive.Drive$Drives$Unhide unhide(String driveId)"}), @ApiMethod(methodName="update", description="Updates the metadata for a shared drive", signatures={"com.google.api.services.drive.Drive$Drives$Update update(String driveId, com.google.api.services.drive.model.Drive content)"})}, aliases={})
@UriParams
@Configurer(extended=true)
public final class DriveDrivesEndpointConfiguration
extends GoogleDriveConfiguration {
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="insert", description="The com.google.api.services.drive.model.Drive"), @ApiMethod(methodName="update", description="The com.google.api.services.drive.model.Drive")})
    private Drive content;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="delete", description="The ID of the shared drive"), @ApiMethod(methodName="get", description="The ID of the shared drive"), @ApiMethod(methodName="hide", description="The ID of the shared drive"), @ApiMethod(methodName="unhide", description="The ID of the shared drive"), @ApiMethod(methodName="update", description="The ID of the shared drive")})
    private String driveId;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="insert", description="An ID, such as a random UUID, which uniquely identifies this user's request for idempotent creation of a shared drive. A repeated request by the same user and with the same request ID will avoid creating duplicates by attempting to create the same shared drive. If the shared drive already exists a 409 error will be returned.")})
    private String requestId;

    public Drive getContent() {
        return this.content;
    }

    public void setContent(Drive content) {
        this.content = content;
    }

    public String getDriveId() {
        return this.driveId;
    }

    public void setDriveId(String driveId) {
        this.driveId = driveId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }
}

