/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.client.http.FileContent;
import com.google.api.client.http.InputStreamContent;
import com.google.api.services.drive.Drive;
import java.io.File;
import java.io.InputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.google.drive.GoogleDriveComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(generateLoader=true)
public final class GoogleDriveFilesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleDriveFilesConverter.class);

    private GoogleDriveFilesConverter() {
    }

    @Converter
    public static com.google.api.services.drive.model.File genericFileToGoogleDriveFile(GenericFile<?> file, Exchange exchange) throws Exception {
        if (file.getFile() instanceof File) {
            File f = (File)file.getFile();
            com.google.api.services.drive.model.File fileMetadata = new com.google.api.services.drive.model.File();
            fileMetadata.setName(f.getName());
            FileContent mediaContent = new FileContent(null, f);
            if (exchange != null) {
                exchange.getIn().setHeader("CamelGoogleDrive.content", (Object)fileMetadata);
                exchange.getIn().setHeader("CamelGoogleDrive.mediaContent", (Object)mediaContent);
            }
            return fileMetadata;
        }
        if (exchange != null) {
            file.getBinding().loadContent(exchange, file);
            InputStream is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, exchange, file.getBody());
            com.google.api.services.drive.model.File fileMetadata = new com.google.api.services.drive.model.File();
            fileMetadata.setName(file.getFileName());
            InputStreamContent mediaContent = new InputStreamContent(null, is);
            exchange.getIn().setHeader("CamelGoogleDrive.content", (Object)fileMetadata);
            exchange.getIn().setHeader("CamelGoogleDrive.mediaContent", (Object)mediaContent);
            return fileMetadata;
        }
        return null;
    }

    private static Drive getClient(Exchange exchange) {
        GoogleDriveComponent component = (GoogleDriveComponent)exchange.getContext().getComponent("google-drive", GoogleDriveComponent.class);
        return component.getClient(component.getConfiguration());
    }
}

