/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.secret.manager;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerConfiguration;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="google-secret-manager")
public class GoogleSecretManagerComponent
extends DefaultComponent {
    @Metadata
    private GoogleSecretManagerConfiguration configuration = new GoogleSecretManagerConfiguration();

    public GoogleSecretManagerComponent() {
    }

    public GoogleSecretManagerComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Project id must be specified.");
        }
        GoogleSecretManagerConfiguration endpointConfiguration = this.configuration != null ? this.configuration.copy() : new GoogleSecretManagerConfiguration();
        endpointConfiguration.setProject(remaining);
        GoogleSecretManagerEndpoint endpoint = new GoogleSecretManagerEndpoint(uri, this, endpointConfiguration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public GoogleSecretManagerConfiguration getConfiguration() {
        return this.configuration;
    }
}

