/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.secret.manager;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerPropertiesFunction;
import org.apache.camel.component.google.secret.manager.vault.PubsubReloadTriggerTask;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.vault.GcpVaultConfiguration;

@DevConsole(value="gcp-secrets")
public class GoogleSecretManagerDevConsole
extends AbstractDevConsole {
    private GoogleSecretManagerPropertiesFunction propertiesFunction;
    private PubsubReloadTriggerTask secretsRefreshTask;

    public GoogleSecretManagerDevConsole() {
        super("camel", "gcp-secrets", "GCP Secrets", "GCP Secret Manager");
    }

    protected void doStart() throws Exception {
        GcpVaultConfiguration gcp;
        PropertiesFunction pf;
        super.doStart();
        if (this.getCamelContext().getPropertiesComponent().hasPropertiesFunction("gcp") && (pf = this.getCamelContext().getPropertiesComponent().getPropertiesFunction("gcp")) instanceof GoogleSecretManagerPropertiesFunction) {
            this.propertiesFunction = (GoogleSecretManagerPropertiesFunction)pf;
        }
        if ((gcp = this.getCamelContext().getVaultConfiguration().getGcpVaultConfiguration()) != null && gcp.isRefreshEnabled()) {
            PeriodTaskScheduler scheduler = PluginHelper.getPeriodTaskScheduler((CamelContext)this.getCamelContext());
            this.secretsRefreshTask = (PubsubReloadTriggerTask)scheduler.getTaskByType(PubsubReloadTriggerTask.class);
        }
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        if (this.propertiesFunction != null) {
            sb.append("GCP Secret Manager:");
            if (this.propertiesFunction.isUseDefaultInstance()) {
                sb.append("\n    Login: Default Instance");
            } else {
                sb.append("\n    Login: Service Account Key File");
            }
            GcpVaultConfiguration gcp = this.getCamelContext().getVaultConfiguration().getGcpVaultConfiguration();
            if (gcp != null) {
                sb.append(String.format("\n    Refresh Enabled: %s", gcp.isRefreshEnabled()));
                sb.append(String.format("\n    Refresh Period: %s", gcp.getRefreshPeriod()));
            }
            if (this.secretsRefreshTask != null) {
                Instant last = this.secretsRefreshTask.getLastCheckTime();
                String s = last != null ? TimeUtils.printSince((long)last.toEpochMilli()) : "none";
                sb.append(String.format("\n    Last Check: %s", s));
                last = this.secretsRefreshTask.getLastReloadTime();
                s = last != null ? TimeUtils.printSince((long)last.toEpochMilli()) : "none";
                sb.append(String.format("\n    Last Reload: %s", s));
            }
            sb.append("\n\nSecrets in use:");
            ArrayList<String> sorted = new ArrayList<String>(this.propertiesFunction.getSecrets());
            Collections.sort(sorted);
            for (String sec : sorted) {
                String age;
                Instant last = this.secretsRefreshTask != null ? this.secretsRefreshTask.getUpdates().get(sec) : null;
                String string = age = last != null ? TimeUtils.printSince((long)last.toEpochMilli()) : null;
                if (age != null) {
                    sb.append(String.format("\n    %s (age: %s)", sec, age));
                    continue;
                }
                sb.append(String.format("\n    %s", sec));
            }
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        if (this.propertiesFunction != null) {
            if (this.propertiesFunction.isUseDefaultInstance()) {
                root.put((Object)"login", (Object)"Default Instance");
            } else {
                root.put((Object)"login", (Object)"Service Account Key File");
            }
            GcpVaultConfiguration gcp = this.getCamelContext().getVaultConfiguration().getGcpVaultConfiguration();
            if (gcp != null) {
                root.put((Object)"refreshEnabled", (Object)gcp.isRefreshEnabled());
                root.put((Object)"refreshPeriod", (Object)gcp.getRefreshPeriod());
            }
            if (this.secretsRefreshTask != null) {
                long timestamp;
                Instant last = this.secretsRefreshTask.getLastCheckTime();
                if (last != null) {
                    timestamp = last.toEpochMilli();
                    root.put((Object)"lastCheckTimestamp", (Object)timestamp);
                    root.put((Object)"lastCheckAge", (Object)TimeUtils.printSince((long)timestamp));
                }
                if ((last = this.secretsRefreshTask.getLastReloadTime()) != null) {
                    timestamp = last.toEpochMilli();
                    root.put((Object)"lastReloadTimestamp", (Object)timestamp);
                    root.put((Object)"lastReloadAge", (Object)TimeUtils.printSince((long)timestamp));
                }
            }
            JsonArray arr = new JsonArray();
            root.put((Object)"secrets", (Object)arr);
            ArrayList<String> sorted = new ArrayList<String>(this.propertiesFunction.getSecrets());
            Collections.sort(sorted);
            for (String sec : sorted) {
                Instant last;
                JsonObject jo = new JsonObject();
                jo.put((Object)"name", (Object)sec);
                Instant instant = last = this.secretsRefreshTask != null ? this.secretsRefreshTask.getUpdates().get(sec) : null;
                if (last != null) {
                    long timestamp = last.toEpochMilli();
                    jo.put((Object)"timestamp", (Object)timestamp);
                    jo.put((Object)"age", (Object)TimeUtils.printSince((long)timestamp));
                }
                arr.add((Object)jo);
            }
        }
        return root;
    }
}

