/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.secret.manager;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretManagerServiceSettings;
import com.google.common.base.Strings;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerConfiguration;
import org.apache.camel.support.ResourceHelper;

public final class GoogleSecretManagerClientFactory {
    private GoogleSecretManagerClientFactory() {
    }

    public static SecretManagerServiceClient create(CamelContext context, GoogleSecretManagerConfiguration configuration) throws Exception {
        SecretManagerServiceClient secretManagerServiceClient = null;
        if (!Strings.isNullOrEmpty((String)configuration.getServiceAccountKey())) {
            InputStream resolveMandatoryResourceAsInputStream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)configuration.getServiceAccountKey());
            ServiceAccountCredentials myCredentials = ServiceAccountCredentials.fromStream((InputStream)resolveMandatoryResourceAsInputStream);
            SecretManagerServiceSettings settings = ((SecretManagerServiceSettings.Builder)SecretManagerServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)myCredentials))).build();
            secretManagerServiceClient = SecretManagerServiceClient.create((SecretManagerServiceSettings)settings);
        } else {
            SecretManagerServiceSettings settings = SecretManagerServiceSettings.newBuilder().build();
            secretManagerServiceClient = SecretManagerServiceClient.create((SecretManagerServiceSettings)settings);
        }
        return secretManagerServiceClient;
    }
}

