/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.storage;

import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import org.apache.camel.CamelContext;
import org.apache.camel.component.google.storage.GoogleCloudStorageComponent;
import org.apache.camel.component.google.storage.GoogleCloudStorageConfiguration;
import org.apache.camel.component.google.storage.GoogleCloudStorageOperations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class GoogleCloudStorageComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private GoogleCloudStorageConfiguration getOrCreateConfiguration(GoogleCloudStorageComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new GoogleCloudStorageConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        GoogleCloudStorageComponent target = (GoogleCloudStorageComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autocreatebucket": 
            case "autoCreateBucket": {
                this.getOrCreateConfiguration(target).setAutoCreateBucket((Boolean)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((GoogleCloudStorageConfiguration)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, GoogleCloudStorageConfiguration.class, (Object)value));
                return true;
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                this.getOrCreateConfiguration(target).setDeleteAfterRead((Boolean)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "destinationbucket": 
            case "destinationBucket": {
                this.getOrCreateConfiguration(target).setDestinationBucket((String)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "downloadfilename": 
            case "downloadFileName": {
                this.getOrCreateConfiguration(target).setDownloadFileName((String)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "filter": {
                this.getOrCreateConfiguration(target).setFilter((String)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "includebody": 
            case "includeBody": {
                this.getOrCreateConfiguration(target).setIncludeBody((Boolean)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "includefolders": 
            case "includeFolders": {
                this.getOrCreateConfiguration(target).setIncludeFolders((Boolean)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "moveafterread": 
            case "moveAfterRead": {
                this.getOrCreateConfiguration(target).setMoveAfterRead((Boolean)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "objectname": 
            case "objectName": {
                this.getOrCreateConfiguration(target).setObjectName((String)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((GoogleCloudStorageOperations)((Object)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, GoogleCloudStorageOperations.class, (Object)value)));
                return true;
            }
            case "serviceaccountkey": 
            case "serviceAccountKey": {
                this.getOrCreateConfiguration(target).setServiceAccountKey((String)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "storageclass": 
            case "storageClass": {
                this.getOrCreateConfiguration(target).setStorageClass((StorageClass)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, StorageClass.class, (Object)value));
                return true;
            }
            case "storageclient": 
            case "storageClient": {
                this.getOrCreateConfiguration(target).setStorageClient((Storage)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, Storage.class, (Object)value));
                return true;
            }
            case "storagelocation": 
            case "storageLocation": {
                this.getOrCreateConfiguration(target).setStorageLocation((String)GoogleCloudStorageComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"storageClient"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autocreatebucket": 
            case "autoCreateBucket": {
                return Boolean.TYPE;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return GoogleCloudStorageConfiguration.class;
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                return Boolean.TYPE;
            }
            case "destinationbucket": 
            case "destinationBucket": {
                return String.class;
            }
            case "downloadfilename": 
            case "downloadFileName": {
                return String.class;
            }
            case "filter": {
                return String.class;
            }
            case "includebody": 
            case "includeBody": {
                return Boolean.TYPE;
            }
            case "includefolders": 
            case "includeFolders": {
                return Boolean.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "moveafterread": 
            case "moveAfterRead": {
                return Boolean.TYPE;
            }
            case "objectname": 
            case "objectName": {
                return String.class;
            }
            case "operation": {
                return GoogleCloudStorageOperations.class;
            }
            case "serviceaccountkey": 
            case "serviceAccountKey": {
                return String.class;
            }
            case "storageclass": 
            case "storageClass": {
                return StorageClass.class;
            }
            case "storageclient": 
            case "storageClient": {
                return Storage.class;
            }
            case "storagelocation": 
            case "storageLocation": {
                return String.class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        GoogleCloudStorageComponent target = (GoogleCloudStorageComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autocreatebucket": 
            case "autoCreateBucket": {
                return this.getOrCreateConfiguration(target).isAutoCreateBucket();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                return this.getOrCreateConfiguration(target).isDeleteAfterRead();
            }
            case "destinationbucket": 
            case "destinationBucket": {
                return this.getOrCreateConfiguration(target).getDestinationBucket();
            }
            case "downloadfilename": 
            case "downloadFileName": {
                return this.getOrCreateConfiguration(target).getDownloadFileName();
            }
            case "filter": {
                return this.getOrCreateConfiguration(target).getFilter();
            }
            case "includebody": 
            case "includeBody": {
                return this.getOrCreateConfiguration(target).isIncludeBody();
            }
            case "includefolders": 
            case "includeFolders": {
                return this.getOrCreateConfiguration(target).isIncludeFolders();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "moveafterread": 
            case "moveAfterRead": {
                return this.getOrCreateConfiguration(target).isMoveAfterRead();
            }
            case "objectname": 
            case "objectName": {
                return this.getOrCreateConfiguration(target).getObjectName();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "serviceaccountkey": 
            case "serviceAccountKey": {
                return this.getOrCreateConfiguration(target).getServiceAccountKey();
            }
            case "storageclass": 
            case "storageClass": {
                return this.getOrCreateConfiguration(target).getStorageClass();
            }
            case "storageclient": 
            case "storageClient": {
                return this.getOrCreateConfiguration(target).getStorageClient();
            }
            case "storagelocation": 
            case "storageLocation": {
                return this.getOrCreateConfiguration(target).getStorageLocation();
            }
        }
        return null;
    }
}

