/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.storage;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.storage.Storage;
import java.util.Map;
import org.apache.camel.component.google.storage.GoogleCloudStorageConfiguration;
import org.apache.camel.component.google.storage.GoogleCloudStorageConsumer;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;

public class GoogleCloudStorageConsumerHealthCheck
extends AbstractHealthCheck {
    private final GoogleCloudStorageConsumer googleCloudStorageConsumer;

    public GoogleCloudStorageConsumerHealthCheck(GoogleCloudStorageConsumer googleCloudStorageConsumer, String routeId) {
        super("camel", "google-cloud-storage-consumer-" + routeId);
        this.googleCloudStorageConsumer = googleCloudStorageConsumer;
    }

    public boolean isLiveness() {
        return false;
    }

    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        try {
            GoogleCloudStorageConfiguration configuration = this.googleCloudStorageConsumer.getConfiguration();
            Storage client = ObjectHelper.isNotEmpty((Object)configuration.getStorageClient()) ? configuration.getStorageClient() : this.googleCloudStorageConsumer.getStorageClient();
            client.list(new Storage.BucketListOption[0]);
        }
        catch (ApiException e) {
            builder.message(e.getMessage());
            builder.error((Throwable)e);
            if (ObjectHelper.isNotEmpty((Object)e.getStatusCode())) {
                builder.detail("service.status.code", (Object)e.getStatusCode());
            }
            if (ObjectHelper.isNotEmpty((Object)e.getStatusCode().getCode())) {
                builder.detail("service.error.code", (Object)e.getStatusCode().getCode());
            }
            builder.down();
            return;
        }
        catch (Exception e) {
            builder.error((Throwable)e);
            builder.down();
            return;
        }
        builder.up();
    }
}

