/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.graphql;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.graphql.GraphqlProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.json.JsonObject;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;

@UriEndpoint(firstVersion="3.0.0", scheme="graphql", title="GraphQL", syntax="graphql:httpUri", category={Category.API}, producerOnly=true)
public class GraphqlEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true)
    private URI httpUri;
    @UriParam
    private String proxyHost;
    @UriParam(label="security", secret=true)
    private String accessToken;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="security", defaultValue="Bearer")
    private String jwtAuthorizationType;
    @UriParam
    private String query;
    @UriParam
    private String queryFile;
    @UriParam
    private String operationName;
    @UriParam
    private JsonObject variables;
    private CloseableHttpClient httpClient;

    public GraphqlEndpoint(String uri, Component component) {
        super(uri, component);
    }

    protected void doStop() throws Exception {
        HttpClientUtils.closeQuietly((HttpClient)this.httpClient);
    }

    public Producer createProducer() throws Exception {
        return new GraphqlProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages at this endpoint: " + this.getEndpointUri());
    }

    public CloseableHttpClient getHttpclient() {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        return this.httpClient;
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (this.proxyHost != null) {
            String[] parts = this.proxyHost.split(":");
            String hostname = parts[0];
            int port = Integer.parseInt(parts[1]);
            httpClientBuilder.setProxy(new HttpHost(hostname, port));
        }
        if (this.accessToken != null) {
            String authType = "Bearer";
            if (this.jwtAuthorizationType != null) {
                authType = this.jwtAuthorizationType;
            }
            httpClientBuilder.setDefaultHeaders(Arrays.asList(new BasicHeader("Authorization", authType + " " + this.accessToken)));
        }
        if (this.username != null && this.password != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        return httpClientBuilder.build();
    }

    public URI getHttpUri() {
        return this.httpUri;
    }

    public void setHttpUri(URI httpUri) {
        this.httpUri = httpUri;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getQuery() {
        if (this.query == null && this.queryFile != null) {
            try {
                this.query = IOHelper.loadText((InputStream)ObjectHelper.loadResourceAsStream((String)this.queryFile));
            }
            catch (IOException e) {
                throw new RuntimeCamelException("Failed to read query file: " + this.queryFile, (Throwable)e);
            }
        }
        return this.query;
    }

    public void setJwtAuthorizationType(String jwtAuthorizationType) {
        this.jwtAuthorizationType = jwtAuthorizationType;
    }

    public String getJwtAuthorizationType() {
        return this.jwtAuthorizationType;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public void setQueryFile(String queryFile) {
        this.queryFile = queryFile;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public JsonObject getVariables() {
        return this.variables;
    }

    public void setVariables(JsonObject variables) {
        this.variables = variables;
    }
}

