/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.client;

import io.grpc.stub.StreamObserver;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducerCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.component.grpc.GrpcConfiguration;
import org.apache.camel.impl.EmptyProducerCache;
import org.apache.camel.impl.ProducerCache;
import org.apache.camel.util.CamelContextHelper;

public class GrpcResponseRouterStreamObserver
implements StreamObserver<Object> {
    private final Endpoint sourceEndpoint;
    private final GrpcConfiguration configuration;
    private final Endpoint endpoint;
    private final ProducerCache producerCache;

    public GrpcResponseRouterStreamObserver(GrpcConfiguration configuration, Endpoint sourceEndpoint) {
        this.configuration = configuration;
        this.sourceEndpoint = sourceEndpoint;
        this.endpoint = CamelContextHelper.getMandatoryEndpoint((CamelContext)sourceEndpoint.getCamelContext(), (String)configuration.getStreamRepliesTo());
        this.producerCache = new EmptyProducerCache((Object)this, sourceEndpoint.getCamelContext());
    }

    public void onNext(Object o) {
        Exchange exchange = this.sourceEndpoint.createExchange();
        exchange.getIn().setHeader("CamelGrpcEventType", (Object)"onNext");
        exchange.getIn().setBody(o);
        this.doSend(exchange, done -> {});
    }

    public void onError(Throwable throwable) {
        if (this.configuration.isForwardOnError()) {
            Exchange exchange = this.sourceEndpoint.createExchange();
            exchange.getIn().setHeader("CamelGrpcEventType", (Object)"onError");
            exchange.getIn().setBody((Object)throwable);
            this.doSend(exchange, done -> {});
        }
    }

    public void onCompleted() {
        if (this.configuration.isForwardOnCompleted()) {
            Exchange exchange = this.sourceEndpoint.createExchange();
            exchange.getIn().setHeader("CamelGrpcEventType", (Object)"onCompleted");
            this.doSend(exchange, done -> {});
        }
    }

    private void doSend(Exchange ex, AsyncCallback callback) {
        this.producerCache.doInAsyncProducer(this.endpoint, ex, ExchangePattern.InOnly, callback, new AsyncProducerCallback(){

            public boolean doInAsyncProducer(Producer producer, AsyncProcessor asyncProducer, Exchange exchange2, ExchangePattern exchangePattern, AsyncCallback callback2) {
                return asyncProducer.process(exchange2, callback2);
            }
        });
    }
}

