/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyServerBuilder;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.grpc.GrpcAuthType;
import org.apache.camel.component.grpc.GrpcConfiguration;
import org.apache.camel.component.grpc.GrpcEndpoint;
import org.apache.camel.component.grpc.GrpcUtils;
import org.apache.camel.component.grpc.auth.jwt.JwtServerInterceptor;
import org.apache.camel.component.grpc.server.GrpcHeaderInterceptor;
import org.apache.camel.component.grpc.server.GrpcMethodHandler;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcConsumer.class);
    protected final GrpcConfiguration configuration;
    protected final GrpcEndpoint endpoint;
    private Server server;

    public GrpcConsumer(GrpcEndpoint endpoint, Processor processor, GrpcConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    public GrpcConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.server == null) {
            LOG.info("Starting the gRPC server");
            this.initializeServer();
            this.server.start();
            LOG.info("gRPC server started and listening on port: {}", (Object)this.server.getPort());
        }
    }

    protected void doStop() throws Exception {
        if (this.server != null) {
            LOG.debug("Terminating gRPC server");
            this.server.shutdown().shutdownNow();
            this.server = null;
        }
        super.doStop();
    }

    protected void initializeServer() throws Exception {
        NettyServerBuilder serverBuilder = null;
        BindableService bindableService = null;
        ProxyFactory serviceProxy = new ProxyFactory();
        GrpcHeaderInterceptor headerInterceptor = new GrpcHeaderInterceptor();
        GrpcMethodHandler methodHandler = new GrpcMethodHandler(this.endpoint, this);
        serviceProxy.setSuperclass(GrpcUtils.constructGrpcImplBaseClass(this.endpoint.getServicePackage(), this.endpoint.getServiceName(), this.endpoint.getCamelContext()));
        try {
            bindableService = (BindableService)serviceProxy.create(new Class[0], new Object[0], (MethodHandler)methodHandler);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to create bindable proxy service for " + this.configuration.getService());
        }
        if (ObjectHelper.isEmpty((Object)this.configuration.getHost()) || ObjectHelper.isEmpty((Object)this.configuration.getPort())) {
            throw new IllegalArgumentException("No server start properties (host, port) specified");
        }
        LOG.debug("Building gRPC server on {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        serverBuilder = NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        if (this.configuration.getNegotiationType() == NegotiationType.TLS) {
            ObjectHelper.notNull((Object)this.configuration.getKeyCertChainResource(), (String)"keyCertChainResource");
            ObjectHelper.notNull((Object)this.configuration.getKeyResource(), (String)"keyResource");
            ClassResolver classResolver = this.endpoint.getCamelContext().getClassResolver();
            SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((InputStream)ResourceHelper.resolveResourceAsInputStream((ClassResolver)classResolver, (String)this.configuration.getKeyCertChainResource()), (InputStream)ResourceHelper.resolveResourceAsInputStream((ClassResolver)classResolver, (String)this.configuration.getKeyResource()), (String)this.configuration.getKeyPassword()).clientAuth(ClientAuth.REQUIRE).sslProvider(SslProvider.OPENSSL);
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getTrustCertCollectionResource())) {
                sslContextBuilder = sslContextBuilder.trustManager(ResourceHelper.resolveResourceAsInputStream((ClassResolver)classResolver, (String)this.configuration.getTrustCertCollectionResource()));
            }
            serverBuilder = serverBuilder.sslContext(GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder).build());
        }
        if (this.configuration.getAuthenticationType() == GrpcAuthType.JWT) {
            ObjectHelper.notNull((Object)this.configuration.getJwtSecret(), (String)"jwtSecret");
            serverBuilder = (NettyServerBuilder)serverBuilder.intercept((ServerInterceptor)new JwtServerInterceptor(this.configuration.getJwtAlgorithm(), this.configuration.getJwtSecret(), this.configuration.getJwtIssuer(), this.configuration.getJwtSubject()));
        }
        this.server = ((NettyServerBuilder)serverBuilder.addService(ServerInterceptors.intercept((BindableService)bindableService, (ServerInterceptor[])new ServerInterceptor[]{headerInterceptor}))).maxMessageSize(this.configuration.getMaxMessageSize()).flowControlWindow(this.configuration.getFlowControlWindow()).maxConcurrentCallsPerConnection(this.configuration.getMaxConcurrentCallsPerConnection()).build();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        exchange.getIn().setHeader("CamelGrpcEventType", (Object)"onNext");
        return this.doSend(exchange, callback);
    }

    public void onCompleted(Exchange exchange) {
        if (this.configuration.isForwardOnCompleted()) {
            exchange.getIn().setHeader("CamelGrpcEventType", (Object)"onCompleted");
            this.doSend(exchange, done -> {});
        }
    }

    public void onError(Exchange exchange, Throwable error) {
        if (this.configuration.isForwardOnError()) {
            exchange.getIn().setHeader("CamelGrpcEventType", (Object)"onError");
            exchange.getIn().setBody((Object)error);
            this.doSend(exchange, done -> {});
        }
    }

    private boolean doSend(Exchange exchange, AsyncCallback callback) {
        if (this.isRunAllowed()) {
            this.getAsyncProcessor().process(exchange, doneSync -> {
                if (exchange.getException() != null) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
                callback.done(doneSync);
            });
            return false;
        }
        LOG.warn("Consumer not ready to process exchanges. The exchange {} will be discarded", (Object)exchange);
        callback.done(true);
        return true;
    }
}

