/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import io.grpc.ClientInterceptor;
import io.grpc.ServerInterceptor;
import io.grpc.netty.NegotiationType;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.camel.component.grpc.GrpcAuthType;
import org.apache.camel.component.grpc.GrpcConsumerStrategy;
import org.apache.camel.component.grpc.GrpcProducerStrategy;
import org.apache.camel.component.grpc.auth.jwt.JwtAlgorithm;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class GrpcConfiguration {
    @UriPath
    @Metadata(required=true)
    private String host;
    @UriPath
    @Metadata(required=true)
    private int port;
    @UriPath
    @Metadata(required=true)
    private String service;
    @UriParam(label="producer")
    private String method;
    @UriParam(label="security", defaultValue="PLAINTEXT")
    private NegotiationType negotiationType = NegotiationType.PLAINTEXT;
    @UriParam(label="security", defaultValue="NONE")
    private GrpcAuthType authenticationType = GrpcAuthType.NONE;
    @UriParam(label="security", defaultValue="HMAC256")
    private JwtAlgorithm jwtAlgorithm = JwtAlgorithm.HMAC256;
    @UriParam(label="security", secret=true)
    private String jwtSecret;
    @UriParam(label="security")
    private String jwtIssuer;
    @UriParam(label="security")
    private String jwtSubject;
    @UriParam(label="security")
    private String serviceAccountResource;
    @UriParam(label="security")
    private String keyCertChainResource;
    @UriParam(label="security")
    private String keyResource;
    @UriParam(label="security", secret=true)
    private String keyPassword;
    @UriParam(label="security")
    private String trustCertCollectionResource;
    @UriParam(label="producer", defaultValue="SIMPLE")
    private GrpcProducerStrategy producerStrategy = GrpcProducerStrategy.SIMPLE;
    @UriParam(label="producer")
    private String streamRepliesTo;
    @UriParam(label="producer")
    private String userAgent;
    @UriParam(label="consumer", defaultValue="PROPAGATION")
    private GrpcConsumerStrategy consumerStrategy = GrpcConsumerStrategy.PROPAGATION;
    @UriParam(label="consumer", defaultValue="false")
    private boolean forwardOnCompleted;
    @UriParam(label="consumer", defaultValue="false")
    private boolean forwardOnError;
    @UriParam(defaultValue="1048576")
    private int flowControlWindow = 0x100000;
    @UriParam(defaultValue="4194304")
    private int maxMessageSize = 0x400000;
    @UriParam(label="consumer", defaultValue="2147483647")
    private int maxConcurrentCallsPerConnection = Integer.MAX_VALUE;
    @UriParam(label="consumer", defaultValue="false")
    private boolean routeControlledStreamObserver;
    private List<ServerInterceptor> serverInterceptors = Collections.emptyList();
    @UriParam(label="consumer", defaultValue="true")
    private boolean autoDiscoverServerInterceptors = true;
    private List<ClientInterceptor> clientInterceptors = Collections.emptyList();
    @UriParam(label="producer", defaultValue="true")
    private boolean autoDiscoverClientInterceptors = true;
    @UriParam(defaultValue="false", label="advanced", description="Sets whether synchronous processing should be strictly used")
    private boolean synchronous;

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public NegotiationType getNegotiationType() {
        return this.negotiationType;
    }

    public void setNegotiationType(NegotiationType negotiationType) {
        this.negotiationType = negotiationType;
    }

    public GrpcAuthType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(GrpcAuthType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public JwtAlgorithm getJwtAlgorithm() {
        return this.jwtAlgorithm;
    }

    public void setJwtAlgorithm(JwtAlgorithm jwtAlgorithm) {
        this.jwtAlgorithm = jwtAlgorithm;
    }

    public String getJwtSecret() {
        return this.jwtSecret;
    }

    public void setJwtSecret(String jwtSecret) {
        this.jwtSecret = jwtSecret;
    }

    public String getJwtIssuer() {
        return this.jwtIssuer;
    }

    public void setJwtIssuer(String jwtIssuer) {
        this.jwtIssuer = jwtIssuer;
    }

    public String getJwtSubject() {
        return this.jwtSubject;
    }

    public void setJwtSubject(String jwtSubject) {
        this.jwtSubject = jwtSubject;
    }

    public String getServiceAccountResource() {
        return this.serviceAccountResource;
    }

    public void setServiceAccountResource(String serviceAccountResource) {
        this.serviceAccountResource = serviceAccountResource;
    }

    public String getKeyCertChainResource() {
        return this.keyCertChainResource;
    }

    public void setKeyCertChainResource(String keyCertChainResource) {
        this.keyCertChainResource = keyCertChainResource;
    }

    public String getKeyResource() {
        return this.keyResource;
    }

    public void setKeyResource(String keyResource) {
        this.keyResource = keyResource;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getTrustCertCollectionResource() {
        return this.trustCertCollectionResource;
    }

    public void setTrustCertCollectionResource(String trustCertCollectionResource) {
        this.trustCertCollectionResource = trustCertCollectionResource;
    }

    public GrpcConsumerStrategy getConsumerStrategy() {
        return this.consumerStrategy;
    }

    public void setConsumerStrategy(GrpcConsumerStrategy consumerStrategy) {
        this.consumerStrategy = consumerStrategy;
    }

    public boolean isForwardOnCompleted() {
        return this.forwardOnCompleted;
    }

    public void setForwardOnCompleted(boolean forwardOnCompleted) {
        this.forwardOnCompleted = forwardOnCompleted;
    }

    public boolean isForwardOnError() {
        return this.forwardOnError;
    }

    public void setForwardOnError(boolean forwardOnError) {
        this.forwardOnError = forwardOnError;
    }

    public GrpcProducerStrategy getProducerStrategy() {
        return this.producerStrategy;
    }

    public void setProducerStrategy(GrpcProducerStrategy producerStrategy) {
        this.producerStrategy = producerStrategy;
    }

    public String getStreamRepliesTo() {
        return this.streamRepliesTo;
    }

    public void setStreamRepliesTo(String streamRepliesTo) {
        this.streamRepliesTo = streamRepliesTo;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public int getFlowControlWindow() {
        return this.flowControlWindow;
    }

    public void setFlowControlWindow(int flowControlWindow) {
        this.flowControlWindow = flowControlWindow;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public boolean isRouteControlledStreamObserver() {
        return this.routeControlledStreamObserver;
    }

    public void setRouteControlledStreamObserver(boolean routeControlledStreamObserver) {
        this.routeControlledStreamObserver = routeControlledStreamObserver;
    }

    public int getMaxConcurrentCallsPerConnection() {
        return this.maxConcurrentCallsPerConnection;
    }

    public void setMaxConcurrentCallsPerConnection(int maxConcurrentCallsPerConnection) {
        this.maxConcurrentCallsPerConnection = maxConcurrentCallsPerConnection;
    }

    public List<ServerInterceptor> getServerInterceptors() {
        return this.serverInterceptors;
    }

    public void setServerInterceptors(List<ServerInterceptor> serverInterceptors) {
        this.serverInterceptors = serverInterceptors;
    }

    public boolean isAutoDiscoverServerInterceptors() {
        return this.autoDiscoverServerInterceptors;
    }

    public void setAutoDiscoverServerInterceptors(boolean autoDiscoverServerInterceptors) {
        this.autoDiscoverServerInterceptors = autoDiscoverServerInterceptors;
    }

    public List<ClientInterceptor> getClientInterceptors() {
        return this.clientInterceptors;
    }

    public void setClientInterceptors(List<ClientInterceptor> clientInterceptors) {
        this.clientInterceptors = clientInterceptors;
    }

    public boolean isAutoDiscoverClientInterceptors() {
        return this.autoDiscoverClientInterceptors;
    }

    public void setAutoDiscoverClientInterceptors(boolean autoDiscoverClientInterceptors) {
        this.autoDiscoverClientInterceptors = autoDiscoverClientInterceptors;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public void parseURI(URI uri) {
        this.setHost(uri.getHost());
        if (uri.getPort() != -1) {
            this.setPort(uri.getPort());
        }
        this.setService(uri.getPath().substring(1));
    }
}

