/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.client;

import io.grpc.stub.StreamObserver;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.grpc.GrpcConfiguration;
import org.apache.camel.component.grpc.GrpcUtils;
import org.apache.camel.component.grpc.client.GrpcExchangeForwarder;

class GrpcSimpleExchangeForwarder
implements GrpcExchangeForwarder {
    private final GrpcConfiguration configuration;
    private final Object grpcStub;

    public GrpcSimpleExchangeForwarder(GrpcConfiguration configuration, Object grpcStub) {
        this.configuration = configuration;
        this.grpcStub = grpcStub;
    }

    @Override
    public boolean forward(Exchange exchange, StreamObserver<Object> responseObserver, AsyncCallback callback) {
        Message message = exchange.getIn();
        try {
            GrpcUtils.invokeAsyncMethod(this.grpcStub, this.configuration.getMethod(), message.getBody(), responseObserver);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return false;
    }

    @Override
    public void forward(Exchange exchange) {
        Message message = exchange.getIn();
        Object outBody = GrpcUtils.invokeSyncMethod(this.grpcStub, this.configuration.getMethod(), message.getBody());
        exchange.getMessage().setHeaders(exchange.getIn().getHeaders());
        exchange.getMessage().setBody(outBody);
    }

    @Override
    public void shutdown() {
    }
}

