/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyServerBuilder;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.grpc.GrpcAuthType;
import org.apache.camel.component.grpc.GrpcConfiguration;
import org.apache.camel.component.grpc.GrpcConsumerStrategy;
import org.apache.camel.component.grpc.GrpcEndpoint;
import org.apache.camel.component.grpc.auth.jwt.JwtServerInterceptor;
import org.apache.camel.component.grpc.server.BindableServiceFactory;
import org.apache.camel.component.grpc.server.DefaultBindableServiceFactory;
import org.apache.camel.component.grpc.server.GrpcHeaderInterceptor;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcConsumer.class);
    protected final GrpcConfiguration configuration;
    protected final GrpcEndpoint endpoint;
    private Server server;
    private BindableServiceFactory factory;

    public GrpcConsumer(GrpcEndpoint endpoint, Processor processor, GrpcConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    public GrpcConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.server == null) {
            LOG.info("Starting the gRPC server");
            this.initializeServer();
            this.server.start();
            LOG.info("gRPC server started and listening on port: {}", (Object)this.server.getPort());
        }
    }

    protected void doStop() throws Exception {
        if (this.server != null) {
            LOG.debug("Terminating gRPC server");
            this.server.shutdown().shutdownNow();
            this.server = null;
        }
        super.doStop();
    }

    protected void initializeServer() throws Exception {
        BindableService bindableService = this.getBindableServiceFactory().createBindableService(this);
        GrpcHeaderInterceptor headerInterceptor = new GrpcHeaderInterceptor();
        if (!ObjectHelper.isNotEmpty((String)this.configuration.getHost()) || this.configuration.getPort() <= 0) {
            throw new IllegalArgumentException("No server start properties (host, port) specified");
        }
        LOG.debug("Building gRPC server on {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        NettyServerBuilder serverBuilder = NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        if (this.configuration.isRouteControlledStreamObserver() && this.configuration.getConsumerStrategy() == GrpcConsumerStrategy.AGGREGATION) {
            throw new IllegalArgumentException("Consumer strategy AGGREGATION and routeControlledStreamObserver are not compatible. Set the consumer strategy to PROPAGATION or DELEGATION");
        }
        if (this.configuration.getNegotiationType() == NegotiationType.TLS) {
            ObjectHelper.notNull((Object)this.configuration.getKeyCertChainResource(), (String)"keyCertChainResource");
            ObjectHelper.notNull((Object)this.configuration.getKeyResource(), (String)"keyResource");
            SslContextBuilder sslContextBuilder = SslContextBuilder.forServer((InputStream)ResourceHelper.resolveResourceAsInputStream((CamelContext)this.endpoint.getCamelContext(), (String)this.configuration.getKeyCertChainResource()), (InputStream)ResourceHelper.resolveResourceAsInputStream((CamelContext)this.endpoint.getCamelContext(), (String)this.configuration.getKeyResource()), (String)this.configuration.getKeyPassword()).clientAuth(ClientAuth.REQUIRE);
            if (ObjectHelper.isNotEmpty((String)this.configuration.getTrustCertCollectionResource())) {
                sslContextBuilder = sslContextBuilder.trustManager(ResourceHelper.resolveResourceAsInputStream((CamelContext)this.endpoint.getCamelContext(), (String)this.configuration.getTrustCertCollectionResource()));
            }
            serverBuilder = serverBuilder.sslContext(GrpcSslContexts.configure((SslContextBuilder)sslContextBuilder).build());
        }
        if (this.configuration.getAuthenticationType() == GrpcAuthType.JWT) {
            ObjectHelper.notNull((Object)this.configuration.getJwtSecret(), (String)"jwtSecret");
            serverBuilder = (NettyServerBuilder)serverBuilder.intercept((ServerInterceptor)new JwtServerInterceptor(this.configuration.getJwtAlgorithm(), this.configuration.getJwtSecret(), this.configuration.getJwtIssuer(), this.configuration.getJwtSubject()));
        }
        for (ServerInterceptor si : this.configuration.getServerInterceptors()) {
            serverBuilder.intercept(si);
        }
        this.server = ((NettyServerBuilder)serverBuilder.addService(ServerInterceptors.intercept((BindableService)bindableService, (ServerInterceptor[])new ServerInterceptor[]{headerInterceptor}))).maxInboundMessageSize(this.configuration.getMaxMessageSize()).flowControlWindow(this.configuration.getFlowControlWindow()).maxConcurrentCallsPerConnection(this.configuration.getMaxConcurrentCallsPerConnection()).build();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        exchange.getIn().setHeader("CamelGrpcEventType", (Object)"onNext");
        return this.doSend(exchange, callback);
    }

    public void onCompleted(Exchange exchange) {
        if (this.configuration.isForwardOnCompleted()) {
            exchange.getIn().setHeader("CamelGrpcEventType", (Object)"onCompleted");
            this.doSend(exchange, done -> {});
        }
    }

    public void onError(Exchange exchange, Throwable error) {
        if (this.configuration.isForwardOnError()) {
            exchange.getIn().setHeader("CamelGrpcEventType", (Object)"onError");
            exchange.getIn().setBody((Object)error);
            this.doSend(exchange, done -> {});
        }
    }

    private boolean doSend(Exchange exchange, AsyncCallback callback) {
        if (this.isRunAllowed()) {
            this.getAsyncProcessor().process(exchange, doneSync -> {
                if (exchange.getException() != null) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                }
                callback.done(doneSync);
            });
            return false;
        }
        LOG.warn("Consumer not ready to process exchanges. The exchange {} will be discarded", (Object)exchange);
        callback.done(true);
        return true;
    }

    private BindableServiceFactory getBindableServiceFactory() {
        CamelContext context = this.endpoint.getCamelContext();
        if (this.factory == null) {
            BindableServiceFactory bindableServiceFactory = (BindableServiceFactory)CamelContextHelper.lookup((CamelContext)context, (String)"grpcBindableServiceFactory", BindableServiceFactory.class);
            this.factory = bindableServiceFactory != null ? bindableServiceFactory : new DefaultBindableServiceFactory();
        }
        return this.factory;
    }
}

