/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.guava.eventbus;

import com.google.common.eventbus.EventBus;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaEventBusProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GuavaEventBusProducer.class);
    private final EventBus eventBus;

    public GuavaEventBusProducer(Endpoint endpoint, EventBus eventBus) {
        super(endpoint);
        this.eventBus = eventBus;
    }

    public void process(Exchange exchange) throws Exception {
        Object body = exchange.getIn().getBody();
        if (body != null) {
            LOG.debug("Posting: {} to EventBus: {}", body, (Object)this.eventBus);
            this.eventBus.post(body);
        } else {
            LOG.debug("Body is null, cannot post to EventBus");
        }
    }
}

