/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice.jsr250;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.camel.guice.inject.Injectors;
import org.apache.camel.guice.support.AnnotationMemberProviderSupport;

public abstract class NamedProviderSupport<A extends Annotation>
extends AnnotationMemberProviderSupport<A> {
    @Inject
    private Injector injector;
    private Context context;

    public Context getContext() {
        return this.context;
    }

    @Inject(optional=true)
    public void setContext(Context context) {
        this.context = context;
    }

    protected Object provideObjectFromNamedBindingOrJndi(TypeLiteral<?> requiredType, String name) {
        Binding<?> binding = Injectors.getBinding(this.injector, Key.get(requiredType, (Annotation)Names.named((String)name)));
        if (binding != null) {
            return binding.getProvider().get();
        }
        try {
            if (this.context == null) {
                this.context = new InitialContext();
            }
            return this.context.lookup(name);
        }
        catch (NamingException e) {
            throw new ProvisionException("Failed to find name '" + name + "' in JNDI. Cause: " + e, (Throwable)e);
        }
    }

    protected String getValueName(String nameFromAnnotation, Member member) {
        if (nameFromAnnotation == null || nameFromAnnotation.length() == 0) {
            nameFromAnnotation = member.getName();
        }
        if (nameFromAnnotation == null || nameFromAnnotation.length() == 0) {
            throw new IllegalArgumentException("No name defined");
        }
        return nameFromAnnotation;
    }
}

