/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast;

public enum HazelcastOperation {
    PUT("put"),
    DELETE("delete"),
    GET("get"),
    UPDATE("update"),
    QUERY("query"),
    GET_ALL("getAll"),
    CLEAR("clear"),
    PUT_IF_ABSENT("putIfAbsent"),
    ADD_ALL("allAll"),
    REMOVE_ALL("removeAll"),
    RETAIN_ALL("retainAll"),
    EVICT("evict"),
    EVICT_ALL("evictAll"),
    VALUE_COUNT("valueCount"),
    CONTAINS_KEY("containsKey"),
    CONTAINS_VALUE("containsValue"),
    GET_KEYS("keySet"),
    REMOVE_VALUE("removevalue"),
    INCREMENT("increment"),
    DECREMENT("decrement"),
    SET_VALUE("setvalue"),
    DESTROY("destroy"),
    COMPARE_AND_SET("compareAndSet"),
    GET_AND_ADD("getAndAdd"),
    ADD("add"),
    OFFER("offer"),
    PEEK("peek"),
    POLL("poll"),
    REMAINING_CAPACITY("remainingCapacity"),
    DRAIN_TO("drainTo"),
    REMOVE_IF("removeIf"),
    TAKE("take"),
    PUBLISH("publish"),
    READ_ONCE_HEAD("readOnceHeal"),
    READ_ONCE_TAIL("readOnceTail"),
    CAPACITY("capacity");

    private static HazelcastOperation[] values;
    private final String operation;

    private HazelcastOperation(String operation) {
        this.operation = operation;
    }

    public static HazelcastOperation getHazelcastOperation(String name) {
        if (name == null) {
            return null;
        }
        for (HazelcastOperation hazelcastOperation : values) {
            if (!hazelcastOperation.toString().equalsIgnoreCase(name) && !hazelcastOperation.name().equalsIgnoreCase(name)) continue;
            return hazelcastOperation;
        }
        throw new IllegalArgumentException(String.format("Operation '%s' is not supported by this component.", name));
    }

    public String toString() {
        return this.operation;
    }

    static {
        values = HazelcastOperation.values();
    }
}

