/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hazelcast.atomicnumber.HazelcastAtomicnumberEndpoint;
import org.apache.camel.component.hazelcast.instance.HazelcastInstanceEndpoint;
import org.apache.camel.component.hazelcast.list.HazelcastListEndpoint;
import org.apache.camel.component.hazelcast.map.HazelcastMapEndpoint;
import org.apache.camel.component.hazelcast.multimap.HazelcastMultimapEndpoint;
import org.apache.camel.component.hazelcast.queue.HazelcastQueueEndpoint;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaConfiguration;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

public class HazelcastComponent
extends DefaultComponent {
    public HazelcastComponent() {
    }

    public HazelcastComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DefaultEndpoint endpoint = null;
        if (remaining.startsWith("map:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("map:".length()), (char)'/');
            endpoint = new HazelcastMapEndpoint(uri, remaining, this);
        }
        if (remaining.startsWith("multimap:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("multimap:".length()), (char)'/');
            endpoint = new HazelcastMultimapEndpoint(uri, remaining, this);
        }
        if (remaining.startsWith("atomicvalue:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("instance:".length()), (char)'/');
            endpoint = new HazelcastAtomicnumberEndpoint(uri, (Component)this, remaining);
        }
        if (remaining.startsWith("instance:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("instance:".length()), (char)'/');
            endpoint = new HazelcastInstanceEndpoint(uri, this);
        }
        if (remaining.startsWith("queue:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("queue:".length()), (char)'/');
            endpoint = new HazelcastQueueEndpoint(uri, (Component)this, remaining);
        }
        if (remaining.startsWith("seda:")) {
            HazelcastSedaConfiguration config = new HazelcastSedaConfiguration();
            this.setProperties(config, parameters);
            config.setQueueName(remaining.substring(remaining.indexOf(":") + 1, remaining.length()));
            endpoint = new HazelcastSedaEndpoint(uri, this, config);
        }
        if (remaining.startsWith("list:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("list:".length()), (char)'/');
            endpoint = new HazelcastListEndpoint(uri, (Component)this, remaining);
        }
        if (endpoint == null) {
            throw new IllegalArgumentException(String.format("Your URI does not provide a correct 'type' prefix. It should be anything like 'hazelcast:[%s|%s|%s|%s|%s|%s|%s]name' but is '%s'.", "map:", "multimap:", "atomicvalue:", "instance:", "queue:", "seda:", "list:", uri));
        }
        return endpoint;
    }
}

