/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.atomicnumber.HazelcastAtomicnumberEndpoint;
import org.apache.camel.component.hazelcast.instance.HazelcastInstanceEndpoint;
import org.apache.camel.component.hazelcast.list.HazelcastListEndpoint;
import org.apache.camel.component.hazelcast.map.HazelcastMapEndpoint;
import org.apache.camel.component.hazelcast.multimap.HazelcastMultimapEndpoint;
import org.apache.camel.component.hazelcast.queue.HazelcastQueueEndpoint;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaConfiguration;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

public class HazelcastComponent
extends DefaultComponent {
    private HazelcastInstance hazelcastInstance;
    private Boolean createOwnInstance;

    public HazelcastComponent() {
    }

    public HazelcastComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        HazelcastDefaultEndpoint endpoint = null;
        if (remaining.startsWith("map:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("map:".length()), (char)'/');
            endpoint = new HazelcastMapEndpoint(this.hazelcastInstance, uri, remaining, this);
        }
        if (remaining.startsWith("multimap:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("multimap:".length()), (char)'/');
            endpoint = new HazelcastMultimapEndpoint(this.hazelcastInstance, uri, remaining, this);
        }
        if (remaining.startsWith("atomicvalue:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("instance:".length()), (char)'/');
            endpoint = new HazelcastAtomicnumberEndpoint(this.hazelcastInstance, uri, (Component)this, remaining);
        }
        if (remaining.startsWith("instance:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("instance:".length()), (char)'/');
            endpoint = new HazelcastInstanceEndpoint(this.hazelcastInstance, uri, this);
        }
        if (remaining.startsWith("queue:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("queue:".length()), (char)'/');
            endpoint = new HazelcastQueueEndpoint(this.hazelcastInstance, uri, (Component)this, remaining);
        }
        if (remaining.startsWith("seda:")) {
            HazelcastSedaConfiguration config = new HazelcastSedaConfiguration();
            this.setProperties(config, parameters);
            config.setQueueName(remaining.substring(remaining.indexOf(":") + 1, remaining.length()));
            endpoint = new HazelcastSedaEndpoint(this.hazelcastInstance, uri, this, config);
        }
        if (remaining.startsWith("list:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("list:".length()), (char)'/');
            endpoint = new HazelcastListEndpoint(this.hazelcastInstance, uri, (Component)this, remaining);
        }
        if (endpoint == null) {
            throw new IllegalArgumentException(String.format("Your URI does not provide a correct 'type' prefix. It should be anything like 'hazelcast:[%s|%s|%s|%s|%s|%s|%s]name' but is '%s'.", "map:", "multimap:", "atomicvalue:", "instance:", "queue:", "seda:", "list:", uri));
        }
        return endpoint;
    }

    public void doStart() throws Exception {
        super.doStart();
        if (this.hazelcastInstance == null) {
            this.createOwnInstance = true;
            this.hazelcastInstance = Hazelcast.newHazelcastInstance(null);
        }
    }

    public void doStop() throws Exception {
        if (this.createOwnInstance.booleanValue() && this.hazelcastInstance != null) {
            this.hazelcastInstance.getLifecycleService().shutdown();
        }
        super.doStop();
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }
}

