/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.instance;

import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.core.HazelcastInstance;
import java.net.InetSocketAddress;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;

public class HazelcastInstanceConsumer
extends DefaultConsumer {
    public HazelcastInstanceConsumer(HazelcastInstance hazelcastInstance, DefaultEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        hazelcastInstance.getCluster().addMembershipListener((MembershipListener)new HazelcastMembershipListener());
    }

    class HazelcastMembershipListener
    implements MembershipListener {
        HazelcastMembershipListener() {
        }

        public void memberAdded(MembershipEvent event) {
            this.sendExchange(event, "added");
        }

        public void memberRemoved(MembershipEvent event) {
            this.sendExchange(event, "removed");
        }

        private void sendExchange(MembershipEvent event, String action) {
            Exchange exchange = HazelcastInstanceConsumer.this.createExchange(false);
            HazelcastComponentHelper.setListenerHeaders(exchange, "instancelistener", action);
            InetSocketAddress adr = event.getMember().getSocketAddress();
            if (adr != null) {
                exchange.getIn().setHeader("CamelHazelcastInstanceHost", (Object)adr.getHostName());
                exchange.getIn().setHeader("CamelHazelcastInstancePort", (Object)adr.getPort());
            }
            try {
                HazelcastInstanceConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            if (exchange.getException() != null) {
                HazelcastInstanceConsumer.this.getExceptionHandler().handleException("Error processing exchange for Hazelcast consumer on your Hazelcast cluster.", exchange, (Throwable)exchange.getException());
            }
            HazelcastInstanceConsumer.this.releaseExchange(exchange, false);
        }
    }
}

