/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.seda;

import com.hazelcast.core.HazelcastInstance;
import java.util.concurrent.BlockingQueue;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hazelcast.HazelcastCommand;
import org.apache.camel.component.hazelcast.HazelcastConstants;
import org.apache.camel.component.hazelcast.HazelcastDefaultComponent;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaConfiguration;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaConsumer;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.7.0", scheme="hazelcast-seda", title="Hazelcast SEDA", syntax="hazelcast-seda:cacheName", category={Category.CACHE, Category.DATAGRID}, headersClass=HazelcastConstants.class)
public class HazelcastSedaEndpoint
extends HazelcastDefaultEndpoint {
    private final BlockingQueue<Object> queue;
    @UriParam
    private final HazelcastSedaConfiguration configuration;

    public HazelcastSedaEndpoint(HazelcastInstance hazelcastInstance, String uri, HazelcastDefaultComponent component, HazelcastSedaConfiguration configuration) {
        super(hazelcastInstance, uri, (Component)component);
        this.queue = hazelcastInstance.getQueue(configuration.getQueueName());
        this.configuration = configuration;
        if (ObjectHelper.isEmpty((String)configuration.getQueueName())) {
            throw new IllegalArgumentException("Queue name is missing.");
        }
        this.setCommand(HazelcastCommand.seda);
    }

    @Override
    public Producer createProducer() throws Exception {
        return new HazelcastSedaProducer(this, this.getQueue());
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        HazelcastSedaConsumer answer = new HazelcastSedaConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public BlockingQueue<Object> getQueue() {
        return this.queue;
    }

    public HazelcastSedaConfiguration getConfiguration() {
        return this.configuration;
    }
}

