/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.map.listener.MapListener;
import java.util.UUID;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.hazelcast.HazelcastDefaultConsumer;
import org.apache.camel.component.hazelcast.listener.CamelMapListener;

public class HazelcastMapConsumer
extends HazelcastDefaultConsumer {
    private final IMap<Object, Object> cache;
    private UUID listener;

    public HazelcastMapConsumer(HazelcastInstance hazelcastInstance, Endpoint endpoint, Processor processor, String cacheName) {
        super(hazelcastInstance, endpoint, processor, cacheName);
        this.cache = hazelcastInstance.getMap(cacheName);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.listener = this.cache.addEntryListener((MapListener)new CamelMapListener(this, this.cacheName), true);
    }

    protected void doStop() throws Exception {
        this.cache.removeEntryListener(this.listener);
        super.doStop();
    }
}

