/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.multimap;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.multimap.MultiMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastDefaultProducer;
import org.apache.camel.component.hazelcast.HazelcastOperation;

public class HazelcastMultimapProducer
extends HazelcastDefaultProducer {
    private final MultiMap<Object, Object> cache;

    public HazelcastMultimapProducer(HazelcastInstance hazelcastInstance, HazelcastDefaultEndpoint endpoint, String cacheName) {
        super(endpoint);
        this.cache = hazelcastInstance.getMultiMap(cacheName);
    }

    public void process(Exchange exchange) throws Exception {
        Map headers = exchange.getIn().getHeaders();
        Object oid = null;
        if (headers.containsKey("CamelHazelcastObjectId")) {
            oid = headers.get("CamelHazelcastObjectId");
        }
        HazelcastOperation operation = this.lookupOperation(exchange);
        switch (operation) {
            case PUT: {
                this.put(oid, exchange);
                break;
            }
            case GET: {
                this.get(oid, exchange);
                break;
            }
            case DELETE: {
                this.delete(oid);
                break;
            }
            case REMOVE_VALUE: {
                this.removevalue(oid, exchange);
                break;
            }
            case CONTAINS_KEY: {
                this.containsKey(oid, exchange);
                break;
            }
            case CONTAINS_VALUE: {
                this.containsValue(exchange);
                break;
            }
            case CLEAR: {
                this.clear();
                break;
            }
            case VALUE_COUNT: {
                this.valuecount(oid, exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the MULTIMAP cache.", new Object[]{operation, "CamelHazelcastOperationType"}));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void put(Object oid, Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.cache.put(oid, body);
    }

    private void get(Object oid, Exchange exchange) {
        exchange.getMessage().setBody((Object)this.cache.get(oid));
    }

    private void delete(Object oid) {
        this.cache.remove(oid);
    }

    private void removevalue(Object oid, Exchange exchange) {
        this.cache.remove(oid, exchange.getIn().getBody());
    }

    private void valuecount(Object oid, Exchange exchange) {
        exchange.getMessage().setBody((Object)this.cache.valueCount(oid));
    }

    private void clear() {
        this.cache.clear();
    }

    private void containsKey(Object oid, Exchange exchange) {
        exchange.getMessage().setBody((Object)this.cache.containsKey(oid));
    }

    private void containsValue(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        exchange.getMessage().setBody((Object)this.cache.containsValue(body));
    }
}

