/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase;

public enum HBaseAttribute {
    HBASE_ROW_ID("CamelHBaseRowId"),
    HBASE_ROW_TYPE("CamelHBaseRowType"),
    HBASE_MARKED_ROW_ID("CamelHBaseMarkedRowId"),
    HBASE_FAMILY("CamelHBaseFamily"),
    HBASE_QUALIFIER("CamelHBaseQualifier"),
    HBASE_VALUE("CamelHBaseValue"),
    HBASE_VALUE_TYPE("CamelHBaseValueType");

    private final String value;
    private final String option;

    private HBaseAttribute(String value) {
        this.value = value;
        this.option = HBaseAttribute.asOption(value);
    }

    public String asHeader(int i) {
        if (i > 1) {
            return this.value + i;
        }
        return this.value;
    }

    public String asHeader() {
        return this.value;
    }

    public String asOption() {
        return this.option;
    }

    public String asOption(int i) {
        if (i > 1) {
            return this.option + i;
        }
        return this.option;
    }

    public String toString() {
        return this.value;
    }

    private static String asOption(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(name, "CamelHBase".length(), name.length());
        sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        return sb.toString();
    }
}

