/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase.converter;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.hbase.converter.HBaseModelConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class HBaseModelConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        HBaseModelConverterLoader.addTypeConverter(registry, byte[].class, Boolean.class, false, (type, exchange, value) -> HBaseModelConverter.booleanToBytes((Boolean)value));
        HBaseModelConverterLoader.addTypeConverter(registry, byte[].class, Double.class, false, (type, exchange, value) -> HBaseModelConverter.doubleToBytes((Double)value));
        HBaseModelConverterLoader.addTypeConverter(registry, byte[].class, Float.class, false, (type, exchange, value) -> HBaseModelConverter.floatToBytes((Float)value));
        HBaseModelConverterLoader.addTypeConverter(registry, byte[].class, Integer.class, false, (type, exchange, value) -> HBaseModelConverter.integerToBytes((Integer)value));
        HBaseModelConverterLoader.addTypeConverter(registry, byte[].class, Long.class, false, (type, exchange, value) -> HBaseModelConverter.longToBytes((Long)value));
        HBaseModelConverterLoader.addTypeConverter(registry, byte[].class, Short.class, false, (type, exchange, value) -> HBaseModelConverter.shortToBytes((Short)value));
        HBaseModelConverterLoader.addTypeConverter(registry, Boolean.class, byte[].class, false, (type, exchange, value) -> HBaseModelConverter.bytesToBoolean((byte[])value));
        HBaseModelConverterLoader.addTypeConverter(registry, Double.class, byte[].class, false, (type, exchange, value) -> HBaseModelConverter.bytesToDouble((byte[])value));
        HBaseModelConverterLoader.addTypeConverter(registry, Float.class, byte[].class, false, (type, exchange, value) -> HBaseModelConverter.bytesToFloat((byte[])value));
        HBaseModelConverterLoader.addTypeConverter(registry, Integer.class, byte[].class, false, (type, exchange, value) -> HBaseModelConverter.bytesToInteger((byte[])value));
        HBaseModelConverterLoader.addTypeConverter(registry, Long.class, byte[].class, false, (type, exchange, value) -> HBaseModelConverter.bytesToLong((byte[])value));
        HBaseModelConverterLoader.addTypeConverter(registry, Short.class, byte[].class, false, (type, exchange, value) -> HBaseModelConverter.bytesToShort((byte[])value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

