/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hbase.model;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.hbase.model.HBaseCell;

public class HBaseRow
implements Cloneable {
    private Object id;
    private Class<?> rowType = String.class;
    private Set<HBaseCell> cells;
    private long timestamp;

    public HBaseRow() {
        this(new LinkedHashSet<HBaseCell>());
    }

    public HBaseRow(Set<HBaseCell> cells) {
        this.cells = cells;
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public Class<?> getRowType() {
        return this.rowType;
    }

    public void setRowType(Class<?> rowType) {
        this.rowType = rowType;
    }

    public Set<HBaseCell> getCells() {
        return this.cells;
    }

    public void setCells(Set<HBaseCell> cells) {
        this.cells = cells;
    }

    public boolean isEmpty() {
        return this.cells.isEmpty();
    }

    public int size() {
        return this.cells.size();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void apply(HBaseRow modelRow) {
        if (modelRow != null) {
            if (this.rowType == null && modelRow.getRowType() != null) {
                this.rowType = modelRow.getRowType();
            }
            for (HBaseCell modelCell : modelRow.getCells()) {
                if (this.getCells().contains(modelCell)) continue;
                HBaseCell cell = new HBaseCell();
                cell.setFamily(modelCell.getFamily());
                cell.setQualifier(modelCell.getQualifier());
                cell.setValueType(modelCell.getValueType());
                this.getCells().add(cell);
            }
        }
    }
}

