/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import org.apache.camel.component.hdfs.HdfsConfiguration;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum HdfsFileSystemType {
    LOCAL{

        @Override
        public StringBuilder getHdfsPath(HdfsConfiguration config) {
            StringBuilder hpath = new StringBuilder();
            hpath.append("file://");
            hpath.append(config.getPath());
            if (config.hasSplitStrategies()) {
                hpath.append('/');
            }
            return hpath;
        }
    }
    ,
    HDFS{

        @Override
        public StringBuilder getHdfsPath(HdfsConfiguration config) {
            StringBuilder hpath = new StringBuilder();
            hpath.append("hdfs://");
            hpath.append(config.getHostName());
            if (!config.hasClusterConfiguration()) {
                hpath.append(':').append(config.getPort());
            }
            hpath.append(config.getPath());
            if (config.hasSplitStrategies()) {
                hpath.append('/');
            }
            return hpath;
        }
    };


    public abstract StringBuilder getHdfsPath(HdfsConfiguration var1);
}

