/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.camel.component.hdfs.HaConfigurationBuilder;
import org.apache.camel.component.hdfs.HdfsComponent;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsInfo;
import org.apache.camel.component.hdfs.kerberos.KerberosAuthentication;
import org.apache.camel.component.hdfs.kerberos.KerberosConfigurationBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class HdfsInfoFactory {
    private final HdfsConfiguration endpointConfig;

    HdfsInfoFactory(HdfsConfiguration endpointConfig) {
        this.endpointConfig = endpointConfig;
    }

    HdfsInfo newHdfsInfo(String hdfsPath) throws IOException {
        return HdfsInfoFactory.newHdfsInfo(hdfsPath, this.endpointConfig);
    }

    HdfsInfo newHdfsInfoWithoutAuth(String hdfsPath) throws IOException {
        return HdfsInfoFactory.newHdfsInfoWithoutAuth(hdfsPath, this.endpointConfig);
    }

    HdfsConfiguration getEndpointConfig() {
        return this.endpointConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HdfsInfo newHdfsInfo(String hdfsPath, HdfsConfiguration endpointConfig) throws IOException {
        javax.security.auth.login.Configuration auth = HdfsComponent.getJAASConfiguration();
        try {
            HdfsInfo hdfsInfo = HdfsInfoFactory.newHdfsInfoWithoutAuth(hdfsPath, endpointConfig);
            return hdfsInfo;
        }
        finally {
            HdfsComponent.setJAASConfiguration(auth);
        }
    }

    private static HdfsInfo newHdfsInfoWithoutAuth(String hdfsPath, HdfsConfiguration endpointConfig) throws IOException {
        Configuration configuration = HdfsInfoFactory.newConfiguration(endpointConfig);
        HdfsInfoFactory.authenticate(configuration, endpointConfig);
        FileSystem fileSystem = HdfsInfoFactory.newFileSystem(configuration, hdfsPath, endpointConfig);
        Path path = new Path(hdfsPath);
        return new HdfsInfo(configuration, fileSystem, path);
    }

    static Configuration newConfiguration(HdfsConfiguration endpointConfig) {
        Configuration configuration = new Configuration();
        if (endpointConfig.isKerberosAuthentication()) {
            KerberosConfigurationBuilder.withKerberosConfiguration(configuration, endpointConfig);
        }
        if (endpointConfig.hasClusterConfiguration()) {
            HaConfigurationBuilder.withClusterConfiguration(configuration, endpointConfig);
        }
        return configuration;
    }

    static void authenticate(Configuration configuration, HdfsConfiguration endpointConfig) throws IOException {
        if (endpointConfig.isKerberosAuthentication()) {
            String userName = endpointConfig.getKerberosUsername();
            String keytabLocation = endpointConfig.getKerberosKeytabLocation();
            new KerberosAuthentication(configuration, userName, keytabLocation).loginWithKeytab();
        }
    }

    static FileSystem newFileSystem(Configuration configuration, String hdfsPath, HdfsConfiguration endpointConfig) throws IOException {
        FileSystem fileSystem = endpointConfig.hasClusterConfiguration() ? FileSystem.get((Configuration)configuration) : FileSystem.get((URI)URI.create(hdfsPath), (Configuration)configuration);
        return fileSystem;
    }
}

