/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.Route;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckConfiguration;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.health.RouteHealthCheck;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.PatternHelper;

@JdkService(value="routes-health-check-repository")
@DeferredContextBinding
public class RoutesHealthCheckRepository
implements CamelContextAware,
HealthCheckRepository {
    private final ConcurrentMap<Route, HealthCheck> checks = new ConcurrentHashMap<Route, HealthCheck>();
    private volatile CamelContext context;
    private Map<String, HealthCheckConfiguration> configurations;
    private HealthCheckConfiguration fallbackConfiguration;
    private boolean enabled = true;

    public void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
    }

    public String getId() {
        return "routes";
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public Map<String, HealthCheckConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Map<String, HealthCheckConfiguration> configurations) {
        this.configurations = configurations;
    }

    public void addConfiguration(String id, HealthCheckConfiguration configuration) {
        if ("*".equals(id)) {
            this.fallbackConfiguration = configuration;
        } else {
            if (this.configurations == null) {
                this.configurations = new LinkedHashMap<String, HealthCheckConfiguration>();
            }
            this.configurations.put(id, configuration);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Stream<HealthCheck> stream() {
        return this.context != null && this.enabled ? this.context.getRoutes().stream().filter(route -> route.getId() != null).map(this::toRouteHealthCheck) : Stream.empty();
    }

    private HealthCheck toRouteHealthCheck(Route route) {
        return this.checks.computeIfAbsent(route, r -> {
            RouteHealthCheck rhc = new RouteHealthCheck(route);
            HealthCheckConfiguration hcc = this.matchConfiguration(route.getRouteId());
            if (hcc != null) {
                rhc.setConfiguration(hcc);
            }
            return rhc;
        });
    }

    private HealthCheckConfiguration matchConfiguration(String id) {
        if (this.configurations != null) {
            for (Map.Entry<String, HealthCheckConfiguration> configurationEntry : this.configurations.entrySet()) {
                if (!PatternHelper.matchPattern((String)id, (String)configurationEntry.getKey())) continue;
                return configurationEntry.getValue();
            }
        }
        return this.fallbackConfiguration;
    }
}

