/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.health.HealthCheckResultStrategy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHealthCheck
implements HealthCheck,
CamelContextAware {
    public static final String SERVICE_STATUS_CODE = "service.status.code";
    public static final String SERVICE_ERROR_CODE = "service.error.code";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHealthCheck.class);
    private CamelContext camelContext;
    private boolean enabled = true;
    private final Lock lock = new ReentrantLock();
    private final String group;
    private final String id;
    private final ConcurrentMap<String, Object> meta;

    protected AbstractHealthCheck(String id) {
        this(null, id, null);
    }

    protected AbstractHealthCheck(String group, String id) {
        this(group, id, null);
    }

    protected AbstractHealthCheck(String group, String id, Map<String, Object> meta) {
        this.group = group;
        this.id = (String)ObjectHelper.notNull((Object)id, (String)"HealthCheck ID");
        this.meta = new ConcurrentHashMap<String, Object>();
        if (meta != null) {
            this.meta.putAll(meta);
        }
        this.meta.put("check.id", id);
        if (group != null) {
            this.meta.putIfAbsent("check.group", group);
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.meta);
    }

    public HealthCheck.Result call() {
        return this.call(Collections.emptyMap());
    }

    public HealthCheck.Result call(Map<String, Object> options) {
        HealthCheckResultBuilder builder;
        this.lock.lock();
        try {
            builder = this.doCall(options);
        }
        finally {
            this.lock.unlock();
        }
        HealthCheckResultStrategy strategy = this.customHealthCheckResponseStrategy();
        if (strategy != null) {
            strategy.processResult((HealthCheck)this, options, builder);
        }
        return builder.build();
    }

    protected HealthCheckResultBuilder doCall(Map<String, Object> options) {
        HealthCheckResultBuilder builder = HealthCheckResultBuilder.on((HealthCheck)this);
        HealthCheckRegistry registry = HealthCheckRegistry.get((CamelContext)this.camelContext);
        if (registry != null) {
            builder.state(registry.getInitialState());
        }
        HealthCheck.Kind kind = this.isLiveness() && this.isReadiness() ? (HealthCheck.Kind)options.getOrDefault("check.kind", HealthCheck.Kind.ALL) : (this.isLiveness() ? HealthCheck.Kind.LIVENESS : HealthCheck.Kind.READINESS);
        builder.detail("check.kind", (Object)kind);
        builder.detail("check.id", this.meta.get("check.id"));
        if (this.meta.containsKey("check.group")) {
            builder.detail("check.group", this.meta.get("check.group"));
        }
        int invocationCount = (Integer)this.meta.getOrDefault("invocation.count", 0);
        int failureCount = (Integer)this.meta.getOrDefault("failure.count", 0);
        String failureTime = (String)this.meta.get("failure.time");
        String failureStartTime = (String)this.meta.get("failure.start.time");
        int successCount = (Integer)this.meta.getOrDefault("success.count", 0);
        String successTime = (String)this.meta.get("success.time");
        String successStartTime = (String)this.meta.get("success.start.time");
        String invocationTime = ZonedDateTime.now().format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
        if (!this.isEnabled()) {
            LOG.debug("health-check ({}) {}/{} disabled", new Object[]{kind, this.getGroup(), this.getId()});
            builder.message("Disabled");
            builder.detail("check.enabled", (Object)false);
            builder.unknown();
            return builder;
        }
        LOG.debug("Invoke health-check ({}) {}/{}", new Object[]{kind, this.getGroup(), this.getId()});
        this.doCall(builder, options);
        if (builder.state() == null) {
            builder.unknown();
        }
        if (builder.state() == HealthCheck.State.DOWN) {
            successCount = 0;
            successStartTime = null;
            ++failureCount;
            failureTime = invocationTime;
            if (failureStartTime == null) {
                failureStartTime = invocationTime;
            }
        } else if (builder.state() == HealthCheck.State.UP) {
            failureCount = 0;
            failureStartTime = null;
            ++successCount;
            if (successTime == null) {
                failureTime = null;
            }
            successTime = invocationTime;
            if (successStartTime == null) {
                successStartTime = invocationTime;
            }
        }
        this.meta.put("invocation.time", invocationTime);
        this.meta.put("invocation.count", ++invocationCount);
        this.meta.put("failure.count", failureCount);
        if (failureTime != null) {
            this.meta.put("failure.time", failureTime);
        } else {
            this.meta.remove("failure.time");
        }
        if (failureStartTime != null) {
            this.meta.put("failure.start.time", failureStartTime);
        } else {
            this.meta.remove("failure.start.time");
        }
        this.meta.put("success.count", successCount);
        if (successTime != null) {
            this.meta.put("success.time", successTime);
        } else {
            this.meta.remove("success.time");
        }
        if (successStartTime != null) {
            this.meta.put("success.start.time", successStartTime);
        } else {
            this.meta.remove("success.start.time");
        }
        builder.detail("invocation.time", this.meta.get("invocation.time"));
        builder.detail("invocation.count", this.meta.get("invocation.count"));
        builder.detail("failure.count", this.meta.get("failure.count"));
        if (this.meta.containsKey("failure.time")) {
            builder.detail("failure.time", this.meta.get("failure.time"));
        }
        if (this.meta.containsKey("failure.start.time")) {
            builder.detail("failure.start.time", this.meta.get("failure.start.time"));
        }
        builder.detail("success.count", this.meta.get("success.count"));
        if (this.meta.containsKey("success.time")) {
            builder.detail("success.time", this.meta.get("success.time"));
        }
        if (this.meta.containsKey("success.start.time")) {
            builder.detail("success.start.time", this.meta.get("success.start.time"));
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractHealthCheck)) {
            return false;
        }
        AbstractHealthCheck that = (AbstractHealthCheck)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    protected final void addMetaData(String key, Object value) {
        this.meta.put(key, value);
    }

    protected abstract void doCall(HealthCheckResultBuilder var1, Map<String, Object> var2);

    private HealthCheckResultStrategy customHealthCheckResponseStrategy() {
        if (this.camelContext != null) {
            return (HealthCheckResultStrategy)this.camelContext.getRegistry().findSingleByType(HealthCheckResultStrategy.class);
        }
        return null;
    }
}

