/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hipchat;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.hipchat.HipchatConfiguration;
import org.apache.camel.component.hipchat.HipchatEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HipchatProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(HipchatProducer.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private transient String hipchatProducerToString;

    public HipchatProducer(HipchatEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        String room;
        Message message = this.getMessageForResponse(exchange);
        String user = (String)exchange.getIn().getHeader("HipchatToUser", String.class);
        if (user != null) {
            message.setHeader("HipchatToUserResponseStatus", (Object)this.sendUserMessage(user, exchange));
        }
        if ((room = (String)exchange.getIn().getHeader("HipchatToRoom", String.class)) != null) {
            message.setHeader("HipchatToRoomResponseStatus", (Object)this.sendRoomMessage(room, exchange));
        }
    }

    private StatusLine sendRoomMessage(String room, Exchange exchange) throws IOException, InvalidPayloadException {
        String urlPath = String.format(this.getConfig().withAuthToken("/v2/room/%s/notification"), room);
        String backGroundColor = (String)exchange.getIn().getHeader("HipchatMessageBackgroundColor", String.class);
        Map<String, String> jsonParam = this.getCommonHttpPostParam(exchange);
        if (backGroundColor != null) {
            jsonParam.put("color", backGroundColor);
        }
        LOG.info("Sending message to room: " + room + ", " + MAPPER.writeValueAsString(jsonParam));
        StatusLine statusLine = this.post(UnsafeUriCharactersEncoder.encodeHttpURI((String)urlPath), jsonParam);
        LOG.debug("Response status for send room message: {}", (Object)statusLine);
        return statusLine;
    }

    private StatusLine sendUserMessage(String user, Exchange exchange) throws IOException, InvalidPayloadException {
        String urlPath = String.format(this.getConfig().withAuthToken("/v2/user/%s/message"), user);
        Map<String, String> jsonParam = this.getCommonHttpPostParam(exchange);
        LOG.info("Sending message to user: " + user + ", " + MAPPER.writeValueAsString(jsonParam));
        StatusLine statusLine = this.post(urlPath, jsonParam);
        LOG.debug("Response status for send user message: {}", (Object)statusLine);
        return statusLine;
    }

    private Map<String, String> getCommonHttpPostParam(Exchange exchange) throws InvalidPayloadException {
        String format = (String)exchange.getIn().getHeader("HipchatMessageFormat", (Object)"text", String.class);
        String notify = (String)exchange.getIn().getHeader("HipchatTriggerNotification", String.class);
        HashMap<String, String> jsonMap = new HashMap<String, String>(4);
        jsonMap.put("message", (String)exchange.getIn().getMandatoryBody(String.class));
        if (notify != null) {
            jsonMap.put("notify", notify);
        }
        jsonMap.put("message_format", format);
        return jsonMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatusLine post(String urlPath, Map<String, String> postParam) throws IOException {
        HttpPost httpPost = new HttpPost(this.getConfig().hipChatUrl() + urlPath);
        httpPost.setEntity((HttpEntity)new StringEntity(MAPPER.writeValueAsString(postParam), ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse closeableHttpResponse = this.getConfig().getHttpClient().execute((HttpUriRequest)httpPost);){
            StatusLine statusLine = closeableHttpResponse.getStatusLine();
            return statusLine;
        }
    }

    private Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }

    private HipchatConfiguration getConfig() {
        return this.getEndpoint().getConfiguration();
    }

    public HipchatEndpoint getEndpoint() {
        return (HipchatEndpoint)super.getEndpoint();
    }

    public String toString() {
        if (this.hipchatProducerToString == null) {
            this.hipchatProducerToString = "HipchatProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.hipchatProducerToString;
    }
}

