/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpCredentialsHelper;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.HttpHost;

public class ProxyHttpClientConfigurer
implements HttpClientConfigurer {
    private final String host;
    private final Integer port;
    private final String scheme;
    private final String username;
    private final char[] password;
    private final String domain;
    private final String ntHost;
    private final HttpCredentialsHelper credentialsHelper;

    public ProxyHttpClientConfigurer(String host, Integer port, String scheme) {
        this(host, port, scheme, null, null, null, null, null);
    }

    public ProxyHttpClientConfigurer(String host, Integer port, String scheme, String username, String password, String domain, String ntHost, HttpCredentialsHelper credentialsHelper) {
        this.host = host;
        this.port = port;
        this.scheme = scheme;
        this.username = username;
        this.password = password == null ? new char[]{} : password.toCharArray();
        this.domain = domain;
        this.ntHost = ntHost;
        this.credentialsHelper = credentialsHelper;
    }

    @Override
    public void configureHttpClient(HttpClientBuilder clientBuilder) {
        clientBuilder.setProxy(new HttpHost(this.scheme, this.host, this.port.intValue()));
        if (this.username != null && this.password != null) {
            Object defaultcreds = this.domain != null ? new NTCredentials(this.username, this.password, this.ntHost, this.domain) : new UsernamePasswordCredentials(this.username, this.password);
            clientBuilder.setDefaultCredentialsProvider(this.credentialsHelper.getCredentialsProvider(this.host, this.port, (Credentials)defaultcreds));
        }
    }
}

