/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpCredentialsHelper;
import org.apache.camel.util.json.DeserializationException;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;

public class OAuth2ClientConfigurer
implements HttpClientConfigurer {
    private final String clientId;
    private final String clientSecret;
    private final String tokenEndpoint;

    public OAuth2ClientConfigurer(String clientId, String clientSecret, String tokenEndpoint) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenEndpoint = tokenEndpoint;
    }

    @Override
    public void configureHttpClient(HttpClientBuilder clientBuilder) {
        CloseableHttpClient httpClient = clientBuilder.build();
        clientBuilder.addRequestInterceptorFirst((arg_0, arg_1, arg_2) -> this.lambda$configureHttpClient$1((HttpClient)httpClient, arg_0, arg_1, arg_2));
    }

    private /* synthetic */ void lambda$configureHttpClient$1(HttpClient httpClient, HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        HttpPost httpPost = new HttpPost(this.tokenEndpoint);
        httpPost.addHeader("Authorization", (Object)HttpCredentialsHelper.generateBasicAuthHeader(this.clientId, this.clientSecret));
        httpPost.setEntity((HttpEntity)new StringEntity("grant_type=client_credentials", ContentType.APPLICATION_FORM_URLENCODED));
        httpClient.execute((ClassicHttpRequest)httpPost, response -> {
            try {
                String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response.getCode() != 200) {
                    throw new HttpException("Received error response from token request with Status Code: " + response.getCode());
                }
                String accessToken = ((JsonObject)Jsoner.deserialize((String)responseString)).getString("access_token");
                request.addHeader("Authorization", (Object)("Bearer " + accessToken));
            }
            catch (DeserializationException e) {
                throw new HttpException("Something went wrong when reading token request response", (Throwable)e);
            }
            return null;
        });
    }
}

