/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpCredentialsHelper;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;

public class BasicAuthenticationHttpClientConfigurer
implements HttpClientConfigurer {
    private final String username;
    private final char[] password;
    private final String domain;
    private final String host;
    private final HttpCredentialsHelper credentialsHelper;

    public BasicAuthenticationHttpClientConfigurer(String user, String pwd, String domain, String host, HttpCredentialsHelper credentialsHelper) {
        this.username = user;
        this.password = pwd == null ? new char[]{} : pwd.toCharArray();
        this.domain = domain;
        this.host = host;
        this.credentialsHelper = credentialsHelper;
    }

    @Override
    public void configureHttpClient(HttpClientBuilder clientBuilder) {
        Object defaultcreds = this.domain != null ? new NTCredentials(this.username, this.password, this.host, this.domain) : new UsernamePasswordCredentials(this.username, this.password);
        clientBuilder.setDefaultCredentialsProvider(this.credentialsHelper.getCredentialsProvider(this.host, null, (Credentials)defaultcreds));
    }
}

