/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huaweicloud.sdk.functiongraph.v2.FunctionGraphClient;
import com.huaweicloud.sdk.functiongraph.v2.model.InvokeFunctionRequest;
import com.huaweicloud.sdk.functiongraph.v2.model.InvokeFunctionResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FunctionGraphEndpoint;
import org.apache.camel.FunctionGraphUtils;
import org.apache.camel.models.ClientConfigurations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionGraphProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionGraphProducer.class);
    private FunctionGraphEndpoint endpoint;
    private FunctionGraphClient functionGraphClient;

    public FunctionGraphProducer(FunctionGraphEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    public void process(Exchange exchange) throws Exception {
        ClientConfigurations clientConfigurations = new ClientConfigurations(this.endpoint);
        if (this.functionGraphClient == null) {
            LOG.debug("Initializing SDK client");
            this.functionGraphClient = this.endpoint.initClient();
            LOG.debug("Successfully initialized SDK client");
        }
        this.updateClientConfigs(exchange, clientConfigurations);
        switch (clientConfigurations.getOperation()) {
            case "invokeFunction": {
                this.invokeFunction(exchange, clientConfigurations);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("%s is not a supported operation", clientConfigurations.getOperation()));
            }
        }
    }

    private void invokeFunction(Exchange exchange, ClientConfigurations clientConfigurations) {
        Map request;
        Object body = exchange.getMessage().getBody();
        if (body instanceof Map) {
            request = (Map)exchange.getMessage().getBody(Map.class);
        } else if (body instanceof String) {
            String strBody = (String)exchange.getMessage().getBody(String.class);
            try {
                request = (Map)new ObjectMapper().readValue(strBody, HashMap.class);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Request body must be a JSON or a HashMap");
            }
        } else {
            throw new IllegalArgumentException("Exchange body is mandatory and should be a valid Map or JSON string");
        }
        if (ObjectHelper.isEmpty((String)clientConfigurations.getFunctionName())) {
            throw new IllegalArgumentException("Function name is mandatory for invokeFunction.");
        }
        InvokeFunctionRequest invokeFunctionRequest = new InvokeFunctionRequest().withBody(request).withFunctionUrn(FunctionGraphUtils.composeUrn("urn:fss:%s:%s:function:%s:%s:latest", clientConfigurations)).withXCFFRequestVersion("v1");
        if (ObjectHelper.isNotEmpty((String)clientConfigurations.getXCffLogType())) {
            invokeFunctionRequest.withXCffLogType(clientConfigurations.getXCffLogType());
        }
        InvokeFunctionResponse response = this.functionGraphClient.invokeFunction(invokeFunctionRequest);
        String responseBody = FunctionGraphUtils.extractJsonFieldAsString(response.getResult(), "body");
        exchange.getMessage().setBody((Object)responseBody);
        if (ObjectHelper.isNotEmpty((String)clientConfigurations.getXCffLogType())) {
            exchange.setProperty("CamelHwCloudFgXCffLogs", (Object)response.getLog());
        }
        LOG.debug("Invoke Function results: {}", (Object)response);
    }

    private void updateClientConfigs(Exchange exchange, ClientConfigurations clientConfigurations) {
        if (ObjectHelper.isEmpty((Object)exchange.getProperty("CamelHwCloudFgOperation")) && ObjectHelper.isEmpty((String)this.endpoint.getOperation())) {
            throw new IllegalArgumentException("Operation name not found");
        }
        clientConfigurations.setOperation(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudFgOperation")) ? (String)exchange.getProperty("CamelHwCloudFgOperation") : this.endpoint.getOperation());
        if (ObjectHelper.isEmpty((Object)exchange.getProperty("CamelHwCloudFgFunction")) && ObjectHelper.isEmpty((String)this.endpoint.getFunctionName())) {
            throw new IllegalArgumentException("Function name not found");
        }
        clientConfigurations.setFunctionName(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudFgFunction")) ? (String)exchange.getProperty("CamelHwCloudFgFunction") : this.endpoint.getFunctionName());
        if (ObjectHelper.isEmpty((Object)exchange.getProperty("CamelHwCloudFgPackage")) && ObjectHelper.isEmpty((String)this.endpoint.getFunctionPackage())) {
            clientConfigurations.setFunctionPackage("default");
        } else {
            clientConfigurations.setFunctionPackage(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudFgPackage")) ? (String)exchange.getProperty("CamelHwCloudFgPackage") : this.endpoint.getFunctionPackage());
        }
        if (ObjectHelper.isEmpty((Object)exchange.getProperty("CamelHwCloudFgXCffLogType"))) {
            LOG.warn("No XCffLogType given");
        } else {
            clientConfigurations.setXCffLogType((String)exchange.getProperty("CamelHwCloudFgXCffLogType"));
        }
    }
}

