/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries.handler;

import org.apache.camel.Exchange;
import org.apache.camel.component.aries.HyperledgerAriesEndpoint;
import org.apache.camel.component.aries.UnsupportedServiceException;
import org.apache.camel.component.aries.handler.AbstractServiceHandler;
import org.hyperledger.acy_py.generated.model.IssuerRevRegRecord;
import org.hyperledger.aries.api.revocation.RevRegCreateRequest;
import org.hyperledger.aries.api.revocation.RevRegCreateResponse;
import org.hyperledger.aries.api.revocation.RevokeRequest;

public class RevocationServiceHandler
extends AbstractServiceHandler {
    public RevocationServiceHandler(HyperledgerAriesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange, String service) throws Exception {
        if (service.equals("/revocation/create-registry")) {
            RevRegCreateRequest reqObj = this.assertBody(exchange, RevRegCreateRequest.class);
            IssuerRevRegRecord resObj = (IssuerRevRegRecord)this.createClient().revocationCreateRegistry(reqObj).get();
            exchange.getIn().setBody((Object)resObj);
        } else if (service.equals("/revocation/revoke")) {
            RevokeRequest reqObj = this.assertBody(exchange, RevokeRequest.class);
            RevRegCreateResponse.RevocationModuleResponse resObj = (RevRegCreateResponse.RevocationModuleResponse)this.createClient().revocationRevoke(reqObj).get();
            exchange.getIn().setBody((Object)resObj);
        } else {
            throw new UnsupportedServiceException(service);
        }
    }
}

