/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.aries;

import com.google.gson.JsonObject;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.aries.ConnectionRecordConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.hyperledger.aries.api.connection.ConnectionRecord;

@DeferredContextBinding
public final class ConnectionRecordConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        ConnectionRecordConverterLoader.addTypeConverter(registry, JsonObject.class, ConnectionRecord.class, false, (type, exchange, value) -> ConnectionRecordConverter.toJsonObject((ConnectionRecord)value));
        ConnectionRecordConverterLoader.addTypeConverter(registry, Map.class, ConnectionRecord.class, false, (type, exchange, value) -> ConnectionRecordConverter.toMap((ConnectionRecord)value));
        ConnectionRecordConverterLoader.addTypeConverter(registry, ConnectionRecord.class, JsonObject.class, false, (type, exchange, value) -> ConnectionRecordConverter.toAries((JsonObject)value));
        ConnectionRecordConverterLoader.addTypeConverter(registry, ConnectionRecord.class, String.class, false, (type, exchange, value) -> ConnectionRecordConverter.toAries((String)value));
        ConnectionRecordConverterLoader.addTypeConverter(registry, ConnectionRecord.class, Map.class, false, (type, exchange, value) -> ConnectionRecordConverter.toAries((Map)value));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

