/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries;

import io.nessus.aries.wallet.NessusWallet;
import java.io.IOException;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aries.HyperledgerAriesComponent;
import org.apache.camel.component.aries.HyperledgerAriesConfiguration;
import org.apache.camel.component.aries.HyperledgerAriesProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.hyperledger.aries.AriesClient;

@UriEndpoint(firstVersion="3.19.0", scheme="hyperledger-aries", title="Hyperledger Aries", syntax="aries:walletName", producerOnly=true, category={Category.BLOCKCHAIN, Category.IDENTITY})
public class HyperledgerAriesEndpoint
extends DefaultEndpoint {
    @UriParam
    private HyperledgerAriesConfiguration configuration;

    public HyperledgerAriesEndpoint(String uri, HyperledgerAriesComponent component, HyperledgerAriesConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public HyperledgerAriesComponent getComponent() {
        return (HyperledgerAriesComponent)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Producer createProducer() throws Exception {
        return new HyperledgerAriesProducer(this);
    }

    public HyperledgerAriesConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getWalletName() {
        return this.getConfiguration().getWalletName();
    }

    public NessusWallet getWallet() {
        return this.getComponent().getWallet(this.getWalletName());
    }

    public AriesClient createClient() throws IOException {
        String walletName = this.getWalletName();
        if (this.getWallet() == null && "admin".equals(walletName)) {
            return this.getComponent().adminClient();
        }
        return this.getComponent().createClient(walletName);
    }
}

