/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries.handler;

import io.nessus.aries.util.AssertState;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.aries.HyperledgerAriesEndpoint;
import org.apache.camel.component.aries.UnsupportedServiceException;
import org.apache.camel.component.aries.handler.AbstractServiceHandler;
import org.hyperledger.acy_py.generated.model.DID;
import org.hyperledger.aries.api.credential_definition.CredentialDefinition;
import org.hyperledger.aries.api.credential_definition.CredentialDefinitionFilter;
import org.hyperledger.aries.api.schema.SchemaSendRequest;
import org.hyperledger.aries.api.schema.SchemaSendResponse;
import org.hyperledger.aries.api.schema.SchemasCreatedFilter;

public class CredentialDefinitionsServiceHandler
extends AbstractServiceHandler {
    public CredentialDefinitionsServiceHandler(HyperledgerAriesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange, String service) throws Exception {
        if (service.equals("/credential-definitions/created")) {
            CredentialDefinitionFilter filter = this.maybeBody(exchange, CredentialDefinitionFilter.class);
            if (filter == null) {
                String schemaVersion;
                String schemaName = this.maybeHeader(exchange, "SchemaName", String.class);
                if (schemaName == null) {
                    schemaName = this.getConfiguration().getSchemaName();
                }
                if ((schemaVersion = this.maybeHeader(exchange, "SchemaVersion", String.class)) == null) {
                    schemaVersion = this.getConfiguration().getSchemaVersion();
                }
                filter = CredentialDefinitionFilter.builder().schemaName(schemaName).schemaVersion(schemaVersion).build();
            }
            CredentialDefinition.CredentialDefinitionsCreated resObj = (CredentialDefinition.CredentialDefinitionsCreated)this.createClient().credentialDefinitionsCreated(filter).get();
            exchange.getIn().setBody((Object)resObj);
        } else if (service.equals("/credential-definitions")) {
            CredentialDefinition.CredentialDefinitionRequest credDefReq = this.maybeBody(exchange, CredentialDefinition.CredentialDefinitionRequest.class);
            if (credDefReq == null) {
                Map spec = this.assertBody(exchange, Map.class);
                String schemaName = (String)spec.get("schemaName");
                if (schemaName == null) {
                    schemaName = this.endpoint.getConfiguration().getSchemaName();
                }
                AssertState.notNull((Object)schemaName, (String)"Cannot obtain schemaName");
                String schemaVersion = (String)spec.get("schemaVersion");
                if (schemaVersion == null) {
                    schemaVersion = this.endpoint.getConfiguration().getSchemaVersion();
                }
                AssertState.notNull((Object)schemaVersion, (String)"Cannot obtain schemaVersion");
                Boolean autoSchema = null;
                Object auxValue = spec.get("autoSchema");
                if (auxValue instanceof Boolean) {
                    autoSchema = (boolean)((Boolean)auxValue);
                }
                if (auxValue instanceof String) {
                    autoSchema = Boolean.valueOf((String)auxValue);
                }
                if (autoSchema == null) {
                    autoSchema = this.endpoint.getConfiguration().isAutoSchema();
                }
                DID publicDid = (DID)this.createClient().walletDidPublic().get();
                SchemasCreatedFilter filter = SchemasCreatedFilter.builder().schemaIssuerDid(publicDid.getDid()).schemaName(schemaName).schemaVersion(schemaVersion).build();
                List<String> schemaIds = (List<String>)this.createClient().schemasCreated(filter).get();
                if (schemaIds.isEmpty() && autoSchema.booleanValue()) {
                    List attributes = (List)spec.get("attributes");
                    SchemaSendRequest schemaReq = SchemaSendRequest.builder().schemaName(schemaName).schemaVersion(schemaVersion).attributes(attributes).build();
                    SchemaSendResponse schemaRes = (SchemaSendResponse)this.createClient().schemas(schemaReq).get();
                    schemaIds = Arrays.asList(schemaRes.getSchemaId());
                    this.log.info("Created Schema: {}", (Object)schemaRes);
                }
                AssertState.isFalse((Boolean)schemaIds.isEmpty(), (String)("Cannot obtain schema ids for: " + filter));
                AssertState.isEqual((Object)1, (Object)schemaIds.size(), (String)("Unexpected number of schema ids for: " + filter));
                boolean supportRevocation = false;
                auxValue = spec.get("supportRevocation");
                if (auxValue instanceof Boolean) {
                    supportRevocation = (Boolean)auxValue;
                }
                if (auxValue instanceof String) {
                    supportRevocation = Boolean.valueOf((String)auxValue);
                }
                credDefReq = CredentialDefinition.CredentialDefinitionRequest.builder().supportRevocation(Boolean.valueOf(supportRevocation)).schemaId(schemaIds.get(0)).build();
            }
            CredentialDefinition.CredentialDefinitionResponse resObj = (CredentialDefinition.CredentialDefinitionResponse)this.createClient().credentialDefinitionsCreate(credDefReq).get();
            String credentialDefinitionId = resObj.getCredentialDefinitionId();
            this.log.info("CredentialDefinitionId: {}", (Object)credentialDefinitionId);
            exchange.getIn().setBody((Object)resObj);
        } else {
            throw new UnsupportedServiceException(service);
        }
    }
}

