/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries.handler;

import org.apache.camel.Exchange;
import org.apache.camel.component.aries.HyperledgerAriesEndpoint;
import org.apache.camel.component.aries.UnsupportedServiceException;
import org.apache.camel.component.aries.handler.AbstractServiceHandler;
import org.hyperledger.aries.api.schema.SchemaSendRequest;
import org.hyperledger.aries.api.schema.SchemaSendResponse;

public class SchemasServiceHandler
extends AbstractServiceHandler {
    public SchemasServiceHandler(HyperledgerAriesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange, String service) throws Exception {
        SchemaSendRequest schemaReq;
        if (service.equals("/schemas")) {
            schemaReq = this.assertBody(exchange, SchemaSendRequest.class);
            if (schemaReq.getSchemaName() == null) {
                schemaReq.setSchemaName(this.endpoint.getConfiguration().getSchemaName());
            }
            if (schemaReq.getSchemaVersion() == null) {
                schemaReq.setSchemaVersion(this.endpoint.getConfiguration().getSchemaVersion());
            }
        } else {
            throw new UnsupportedServiceException(service);
        }
        SchemaSendResponse resObj = (SchemaSendResponse)this.createClient().schemas(schemaReq).get();
        exchange.getIn().setBody((Object)resObj);
    }
}

