/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries.handler;

import io.nessus.aries.util.AssertState;
import io.nessus.aries.wallet.NessusWallet;
import io.nessus.aries.wallet.WalletBuilder;
import io.nessus.aries.wallet.WalletRegistry;
import org.apache.camel.Exchange;
import org.apache.camel.component.aries.HyperledgerAriesEndpoint;
import org.apache.camel.component.aries.UnsupportedServiceException;
import org.apache.camel.component.aries.handler.AbstractServiceHandler;
import org.hyperledger.acy_py.generated.model.DID;
import org.hyperledger.acy_py.generated.model.DIDEndpoint;
import org.hyperledger.acy_py.generated.model.TxnOrRegisterLedgerNymResponse;
import org.hyperledger.aries.AriesClient;
import org.hyperledger.aries.api.ledger.IndyLedgerRoles;
import org.hyperledger.aries.api.ledger.RegisterNymFilter;
import org.hyperledger.aries.api.multitenancy.CreateWalletRequest;
import org.hyperledger.aries.api.multitenancy.WalletRecord;
import org.hyperledger.aries.api.wallet.WalletDIDCreate;

public class MultitenancyServiceHandler
extends AbstractServiceHandler {
    public MultitenancyServiceHandler(HyperledgerAriesEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange, String service) throws Exception {
        NessusWallet wallet;
        if (service.equals("/multitenancy/wallet")) {
            CreateWalletRequest walletRequest = this.assertBody(exchange, CreateWalletRequest.class);
            String walletName = walletRequest.getWalletName();
            boolean selfRegister = this.maybeHeader(exchange, "multitenancy/self-register-nym", Boolean.TYPE);
            IndyLedgerRoles ledgerRole = this.maybeHeader(exchange, "multitenancy/ledger-role", IndyLedgerRoles.class);
            String trusteeName = this.maybeHeader(exchange, "multitenancy/trustee-wallet", String.class);
            WalletRegistry walletRegistry = this.getComponent().getWalletRegistry();
            WalletRecord walletRecord = (WalletRecord)this.adminClient().multitenancyWalletCreate(walletRequest).get();
            wallet = NessusWallet.build((WalletRecord)walletRecord).withWalletRegistry(walletRegistry);
            this.getComponent().addWallet(wallet);
            String walletId = wallet.getWalletId();
            this.log.info("{}: [{}] {}", new Object[]{walletName, walletId, wallet});
            if (ledgerRole != null) {
                AssertState.isTrue((Boolean)(selfRegister || trusteeName != null ? 1 : 0), (String)("LedgerRole " + ledgerRole + " requires selfRegister or trusteeWallet"));
                AriesClient client = this.getComponent().createClient(walletName);
                DID did = (DID)client.walletDidCreate(WalletDIDCreate.builder().build()).get();
                this.log.info("{}: {}", (Object)walletName, (Object)did);
                if (trusteeName != null) {
                    AriesClient trustee = this.getComponent().createClient(trusteeName);
                    TxnOrRegisterLedgerNymResponse nymResponse = (TxnOrRegisterLedgerNymResponse)trustee.ledgerRegisterNym(RegisterNymFilter.builder().did(did.getDid()).verkey(did.getVerkey()).role(ledgerRole).build()).get();
                    this.log.info("{} for {}: {}", new Object[]{trusteeName, walletName, nymResponse});
                } else if (selfRegister) {
                    WalletBuilder.selfRegisterWithDid((String)walletName, (String)did.getDid(), (String)did.getVerkey(), (IndyLedgerRoles)ledgerRole);
                }
                client.walletDidPublic(did.getDid());
                wallet.setPublicDid(did);
                DIDEndpoint didEndpoint = (DIDEndpoint)client.walletGetDidEndpoint(did.getDid()).get();
                this.log.info("{}: {}", (Object)walletName, (Object)didEndpoint);
            }
        } else {
            throw new UnsupportedServiceException(service);
        }
        exchange.getIn().setBody((Object)wallet);
    }
}

