/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries.handler;

import io.nessus.aries.util.AssertState;
import io.nessus.aries.websocket.WebSocketListener;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aries.Constants;
import org.apache.camel.component.aries.HyperledgerAriesComponent;
import org.apache.camel.component.aries.HyperledgerAriesConfiguration;
import org.apache.camel.component.aries.HyperledgerAriesEndpoint;
import org.apache.camel.component.aries.handler.ServiceHandler;
import org.hyperledger.aries.AriesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceHandler
implements ServiceHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final HyperledgerAriesEndpoint endpoint;

    public AbstractServiceHandler(HyperledgerAriesEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void beforeProcess(Exchange exchange, String service) {
        String walletName = this.endpoint.getWalletName();
        exchange.setProperty(Constants.PROPERTY_HYPERLEDGER_ARIES_COMPONENT, (Object)this.endpoint.getComponent());
        Message message = exchange.getIn();
        message.setHeader("WalletName", (Object)walletName);
        message.setHeader("WalletRecord", (Object)this.endpoint.getWallet());
        this.log.debug("{}: Before [service={}, body={}, headers={}]", new Object[]{walletName, service, message.getBody(), message.getHeaders()});
    }

    public void afterProcess(Exchange exchange, String service) {
        Message message = exchange.getIn();
        String walletName = this.endpoint.getWalletName();
        this.log.debug("{}: After [service={}, body={}, headers={}]", new Object[]{walletName, service, message.getBody(), message.getHeaders()});
    }

    protected String getServicePathToken(String service, int idx) {
        return service.split("/")[idx + 1];
    }

    public <T> boolean hasBody(Exchange exchange, Class<T> type) {
        return this.maybeBody(exchange, type) != null;
    }

    public <T> T maybeBody(Exchange exchange, Class<T> type) {
        return (T)exchange.getIn().getBody(type);
    }

    public <T> T assertBody(Exchange exchange, Class<T> type) {
        Object body = exchange.getIn().getBody(type);
        AssertState.notNull((Object)body, (String)("Cannot obtain body of type: " + type.getName()));
        return (T)body;
    }

    public boolean hasHeader(Exchange exchange, String key) {
        return exchange.getIn().getHeader(key) != null;
    }

    public <T> T maybeHeader(Exchange exchange, Class<T> type) {
        T value = this.maybeHeader(exchange, type.getSimpleName(), type);
        if (value == null) {
            value = this.maybeHeader(exchange, type.getName(), type);
        }
        return value;
    }

    public <T> T maybeHeader(Exchange exchange, String key, Class<T> type) {
        return (T)exchange.getIn().getHeader(key, type);
    }

    public <T> T assertHeader(Exchange exchange, Class<T> type) {
        T value = this.maybeHeader(exchange, type);
        AssertState.notNull(value, (String)("Cannot obtain header of type: " + type.getName()));
        return value;
    }

    public <T> T assertHeader(Exchange exchange, String key, Class<T> type) {
        T value = this.maybeHeader(exchange, key, type);
        AssertState.notNull(value, (String)("Cannot obtain header '" + key + "' of type: " + type.getName()));
        return value;
    }

    public HyperledgerAriesConfiguration getConfiguration() {
        return this.endpoint.getConfiguration();
    }

    public HyperledgerAriesComponent getComponent() {
        return this.endpoint.getComponent();
    }

    public AriesClient adminClient() {
        return this.getComponent().adminClient();
    }

    public AriesClient createClient() throws IOException {
        return this.endpoint.createClient();
    }

    public WebSocketListener getAdminWebSocketListener() {
        return this.getComponent().getAdminWebSocketListener();
    }
}

