/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aries.handler;

import io.nessus.aries.util.AssertState;
import io.nessus.aries.websocket.WebSocketListener;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.component.aries.HyperledgerAriesEndpoint;
import org.apache.camel.component.aries.UnsupportedServiceException;
import org.apache.camel.component.aries.handler.AbstractServiceHandler;
import org.hyperledger.aries.api.connection.ConnectionRecord;
import org.hyperledger.aries.api.connection.ConnectionState;
import org.hyperledger.aries.api.did_exchange.DidExchangeAcceptInvitationFilter;

public class DidExchangeServiceHandler
extends AbstractServiceHandler {
    public DidExchangeServiceHandler(HyperledgerAriesEndpoint endpoint) {
        super(endpoint);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(Exchange exchange, String service) throws Exception {
        if (!service.startsWith("/didexchange")) throw new UnsupportedServiceException(service);
        String connectionId = this.getServicePathToken(service, 1);
        AssertState.notNull((Object)connectionId, (String)"Null connectionId");
        if (service.endsWith("/accept-invitation")) {
            DidExchangeAcceptInvitationFilter filter = this.maybeHeader(exchange, DidExchangeAcceptInvitationFilter.class);
            ConnectionRecord conrec = (ConnectionRecord)this.adminClient().didExchangeAcceptInvitation(connectionId, filter).get();
            WebSocketListener wsevents = this.getAdminWebSocketListener();
            if (conrec == null && wsevents != null) {
                conrec = wsevents.awaitConnection(cr -> cr.getState() == ConnectionState.COMPLETED && cr.getConnectionId().equals(connectionId), 10L, TimeUnit.SECONDS).findFirst().orElse(null);
            }
            AssertState.notNull((Object)conrec, (String)String.format("No ConnectionRecord for %s", connectionId));
            exchange.getIn().setBody((Object)conrec);
            return;
        } else {
            if (!service.endsWith(connectionId)) throw new UnsupportedServiceException(service);
            WebSocketListener wsevents = this.getAdminWebSocketListener();
            ConnectionRecord conrec = this.createClient().connectionsGetById(connectionId).orElse(null);
            if (conrec == null && wsevents != null) {
                conrec = wsevents.awaitConnection(cr -> cr.getState() == ConnectionState.COMPLETED && cr.getConnectionId().equals(connectionId), 10L, TimeUnit.SECONDS).findFirst().orElse(null);
            }
            AssertState.notNull((Object)conrec, (String)String.format("No ConnectionRecord for %s", connectionId));
            exchange.getIn().setBody((Object)conrec);
        }
    }
}

